package com.scpyun.platform.jilinsscgsdp.check;

import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventFlowLogInsertVo;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @Author liu
 * @Date 2024/5/31 14:42
 * @PackageName:com.scpyun.platform.jilinsscgsdp.utils
 * @ClassName: EventCheckUtils
 * @Description: TODO
 * @Version 1.0
 */
public class EventFlowLogCheckUtils {

    /**
     * 事件日志校验参数
     * @param map
     * @return
     */
    public static String eventFlowLogCheck(Map<String, Object> map) {
        if (!StringUtils.toStr(map.get("log_type")).equals("4")){
            if (StringUtils.isEmpty(map.get("is_special_tasks"))) {
                throw new CustomException("专项任务类别不可为空！");
            }
            if (StringUtils.isEmpty(map.get("id"))) {
                throw new CustomException("事件id不可为空！");
            }
            if (StringUtils.isEmpty(map.get("status"))) {
                throw new CustomException("事件状态不可为空！");
            }
            if (StringUtils.isEmpty(map.get("log_type"))) {
                throw new CustomException("流程id不可为空！");
            }
        }
        return StringUtils.toStr(map.get("log_type"));
    }

    /**
     * 分派事件校验参数
     * @param map
     * @return
     */
    public static List<String> eventFlowLogAssignmentCheck(ReqEventFlowLogInsertVo vo) {
        if (StringUtils.isEmpty(vo.getId())) {
            throw new CustomException("事件id不可为空！");
        }
        if (StringUtils.isEmpty(vo.getStatus())) {
            throw new CustomException("事件状态不可为空！");
        }
        if (StringUtils.isEmpty(vo.getLogType())) {
            throw new CustomException("流程id不可为空！");
        }
        if (CollectionUtils.isEmpty(vo.getOfficeIdList())){
            throw new CustomException("机构id不可为空！");
        }
        return vo.getOfficeIdList();
    }

    /**
     * 横传事件校验参数
     * @param map
     * @return
     */
    public static List<Map<String, Object>> eventFlowLogTransverseCheck(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("id"))) {
            throw new CustomException("事件id不可为空！");
        }
        if (StringUtils.isEmpty(map.get("status"))) {
            throw new CustomException("事件状态不可为空！");
        }
        if (StringUtils.isEmpty(map.get("log_type"))) {
            throw new CustomException("流程id不可为空！");
        }
        List<Map<String, Object>> officeIdList = (List<Map<String, Object>>) map.get("officeIdList");
        if (CollectionUtils.isEmpty(officeIdList)){
            throw new CustomException("机构id不可为空！");
        }
        return officeIdList;
    }
}
