package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.annotation.MethodType;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.JlEventOverdueWarningConfigEntity;
import com.scpyun.platform.jilinsscgsdp.bean.vo.JlEventOverdueWarningConfigInsertVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.JlEventOverdueWarningConfigVo;
import com.scpyun.platform.jilinsscgsdp.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

@Api("超期预警管理配置")
@Service("jlEventOverdueWarningConfigService")
@Validated
public class JlEventOverdueWarningConfigServiceImpl {

    @Autowired
    private CommonService commonService;
    private final String nameSpace_JlEventOverdueWarningConfig = "com.scpyun.platform.standard.jilinsscgsdp.JlEventOverdueWarningConfigDao.";

    @ApiOperation(value = "获取列表", method = MethodType.GET)
    public List<JlEventOverdueWarningConfigVo> findList() {
        List<JlEventOverdueWarningConfigEntity> jlEventOverdueWarningConfigEntityList =
                commonService.findList(nameSpace_JlEventOverdueWarningConfig + "findList", new JlEventOverdueWarningConfigEntity());
        List<JlEventOverdueWarningConfigVo> list = new ArrayList<>();
        if (jlEventOverdueWarningConfigEntityList.isEmpty()) {
            //设置一般矛盾纠纷、复杂矛盾纠纷、重大矛盾纠纷
            list.add(new JlEventOverdueWarningConfigVo("一般矛盾纠纷"));
            list.add(new JlEventOverdueWarningConfigVo("复杂矛盾纠纷"));
            list.add(new JlEventOverdueWarningConfigVo("重大矛盾纠纷"));
            return list;
        } else {
            return BeanUtils.copyListProperties(jlEventOverdueWarningConfigEntityList, JlEventOverdueWarningConfigVo::new);
        }
    }

    @ApiOperation(value = "新增信息", method = MethodType.POST)
    public Object update(@Valid JlEventOverdueWarningConfigInsertVo jlEventOverdueWarningConfigInsertVo) {
        //清除历史信息
        List<JlEventOverdueWarningConfigEntity> jlEventOverdueWarningConfigEntityList =
                commonService.findList(nameSpace_JlEventOverdueWarningConfig + "findList", new JlEventOverdueWarningConfigEntity());
        if (!jlEventOverdueWarningConfigEntityList.isEmpty()) {
            commonService.deleteBatch(nameSpace_JlEventOverdueWarningConfig + "delete", jlEventOverdueWarningConfigEntityList);
        }
        //一般矛盾纠纷
        JlEventOverdueWarningConfigEntity jlEventOverdueWarningConfigEntity1 = new JlEventOverdueWarningConfigEntity(jlEventOverdueWarningConfigInsertVo.getYellowWarnDays1(),
                jlEventOverdueWarningConfigInsertVo.getRedWarnDays1(), jlEventOverdueWarningConfigInsertVo.getRiskType1(), jlEventOverdueWarningConfigInsertVo.get_user().getId());
        commonService.insert(nameSpace_JlEventOverdueWarningConfig + "insert", jlEventOverdueWarningConfigEntity1);
        //复杂矛盾纠纷
        JlEventOverdueWarningConfigEntity jlEventOverdueWarningConfigEntity2 = new JlEventOverdueWarningConfigEntity(jlEventOverdueWarningConfigInsertVo.getYellowWarnDays2(),
                jlEventOverdueWarningConfigInsertVo.getRedWarnDays2(), jlEventOverdueWarningConfigInsertVo.getRiskType2(), jlEventOverdueWarningConfigInsertVo.get_user().getId());
        commonService.insert(nameSpace_JlEventOverdueWarningConfig + "insert", jlEventOverdueWarningConfigEntity2);
        //重大矛盾纠纷
        JlEventOverdueWarningConfigEntity jlEventOverdueWarningConfigEntity3 = new JlEventOverdueWarningConfigEntity(jlEventOverdueWarningConfigInsertVo.getYellowWarnDays3(),
                jlEventOverdueWarningConfigInsertVo.getRedWarnDays3(), jlEventOverdueWarningConfigInsertVo.getRiskType3(), jlEventOverdueWarningConfigInsertVo.get_user().getId());
        commonService.insert(nameSpace_JlEventOverdueWarningConfig + "insert", jlEventOverdueWarningConfigEntity3);
        return "保存成功";
    }

}