package com.scpyun.platform.jilinsscgsdp.bean.vo.task;


import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

public class ReqEventUserVo extends ReqBaseVo {

    /**
     * 是否重点人员 1是 2否
     */
    @NotEmpty(message = "是否重点人员不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-2]$", message = "是否重点人员值必须为1-2", groups = {Insert.class, Update.class})
    private String isKeynote;
    /**
     * 重点人员类别 1:前科劣迹人员 2:社区矫正人员 3精神病患者: 4:三失一偏人员 5:重点青少年
     */
    @Pattern(regexp = "^$|^[1-3]$", message = "重点人员类别值必须为1-5", groups = {Insert.class, Update.class})
    private String keynoteType;

    /**
     * 证件号码
     */
    @NotEmpty(message = "证件号码不可为空", groups = {Insert.class, Update.class})
    @Length(min = 15, max = 18, message = "证件类别长度不可超过18", groups = {Insert.class, Update.class})
    private String eventCardno;
    /**
     * 证件类别 1:身份证 2:护照 3:台湾居民来往大陆通行证 ，如填写证件号码，则此字段必填
     */
    @NotEmpty(message = "证件类别不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-3]$", message = "证件类别值必须为1-3", groups = {Insert.class, Update.class})
    private String eventCardType;
    /**
     * 事件ID
     */
    @NotEmpty(message = "事件ID不可为空", groups = {Insert.class, Update.class})
    private String eventId;
    /**
     * 机构/法定名称
     */
    private String eventRepresent;
    /**
     * 联系电话
     */
    private String eventTel;
    /**
     * 当事人姓名
     */
    @NotEmpty(message = "当事人姓名不可为空", groups = {Insert.class, Update.class})
    @Length(min = 1, max = 50, message = "当事人姓名字符长度不可超过50", groups = {Insert.class, Update.class})
    private String eventUserName;
    /**
     * 当事人类型 1:自然人 2:社会组织 3企业 4:政府机关
     */
    @Pattern(regexp = "^$|^[1-4]$", message = "当事人类型值必须为1-4", groups = {Insert.class, Update.class})
    private String eventUserType;
    /**
     * 主键
     */
    @NotEmpty(message = "id不可为空", groups = {Insert.class, Update.class})
    private String id;
    /**
     * 备注
     */
    private String remark;
    /**
     * 机构/统一社会信用代码
     */
    private String tyshxydm;
    /**
     * 地市对接id
     */
    private String dockingId;
    /**
     * 市编码
     */
    private String cityCode;
    @NotEmpty(message = "appid不可为空", groups = {Insert.class, Update.class})
    private String appid;
    /**
     * 添加状态
     */
    private String type;
    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;

    public String getIsKeynote() {
        return isKeynote;
    }

    public void setIsKeynote(String isKeynote) {
        this.isKeynote = isKeynote;
    }

    public String getKeynoteType() {
        return keynoteType;
    }

    public void setKeynoteType(String keynoteType) {
        this.keynoteType = keynoteType;
    }

    public String getEventCardno() {
        return eventCardno;
    }

    public void setEventCardno(String eventCardno) {
        this.eventCardno = eventCardno;
    }

    public String getEventCardType() {
        return eventCardType;
    }

    public void setEventCardType(String eventCardType) {
        this.eventCardType = eventCardType;
    }

    public String getEventId() {
        return eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventRepresent() {
        return eventRepresent;
    }

    public void setEventRepresent(String eventRepresent) {
        this.eventRepresent = eventRepresent;
    }

    public String getEventTel() {
        return eventTel;
    }

    public void setEventTel(String eventTel) {
        this.eventTel = eventTel;
    }

    public String getEventUserName() {
        return eventUserName;
    }

    public void setEventUserName(String eventUserName) {
        this.eventUserName = eventUserName;
    }

    public String getEventUserType() {
        return eventUserType;
    }

    public void setEventUserType(String eventUserType) {
        this.eventUserType = eventUserType;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getTyshxydm() {
        return tyshxydm;
    }

    public void setTyshxydm(String tyshxydm) {
        this.tyshxydm = tyshxydm;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }
}
