package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.scpyun.base.bean.User;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.core.utils.UUIDUtil;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.RiskFactor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Api("风险因素管理")
@Service("RiskFactorManagement")
public class RiskFactorManagementServiceImpl {

    @Autowired
    CommonService commonService;
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.riiskfactor.";

    @ApiOperation(value = "",nologin = true)
    public List<RiskFactor> selectARiskFactorList(RiskFactor riskFactor) {
        return commonService.findList(nameSpace + "selectARiskFactorList", riskFactor);
    }

    @ApiOperation(value = "")
    public Object deleteRiskFactorById(RiskFactor riskFactor) {
        return commonService.delete(nameSpace + "deleteRiskFactorById", riskFactor);
    }

    @ApiOperation(value = "")
    public Object insertRiskFactor(RiskFactor riskFactor) {
        if (StringUtils.isEmpty(riskFactor.getFactorName())) {
            throw new CustomException("风险因素名称不能为空");
        }
        riskFactor.setId(UUIDUtil.getUUID());
        return commonService.insert(nameSpace + "insertRiskFactor", riskFactor);
    }

    @ApiOperation(value = "")
    public Object updateRiskFactor(RiskFactor riskFactor) {
        if (StringUtils.isEmpty(riskFactor.getId())) {
            throw new RuntimeException("id ?");
        }
        return commonService.update(nameSpace + "updateRiskFactor", riskFactor);
    }


}
