package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSON;
import com.obs.services.model.ObsObject;
import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.KeyPerson;
import com.scpyun.platform.jilinsscgsdp.bean.entity.KeyPerson3Imp;
import com.scpyun.platform.jilinsscgsdp.bean.entity.KeyPersonImp;
import com.scpyun.platform.jilinsscgsdp.bean.entity.KeyPersonRatingHistory;
import com.scpyun.platform.jilinsscgsdp.utils.DataScopeUtil;
import com.scpyun.platform.jilinsscgsdp.utils.FileData3Listener;
import com.scpyun.platform.jilinsscgsdp.utils.FileDataListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author liu
 * @Date 2025/9/25 16:50
 * @PackageName:com.scpyun.platform.jilinsscgsdp.service.impl
 * @ClassName: KeyPersonRating
 * @Description: TODO
 * @Version 1.0
 */
@Api("评分历史功能")
@Service("keyPersonRatingHistoryService")
public class KeyPersonRatingHistoryServiceImpl {
    @Autowired
    CommonService commonService;

    private static final Logger log = LoggerFactory.getLogger(KeyPersonRatingHistoryServiceImpl.class);

    private final String SUCCESS = "success";

    private String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyPersonRatingHistory.";

    @ApiOperation(value = "查询评分历史列表", desc = "查询评分历史列表")
    public Page<KeyPersonRatingHistory> selectRatingHistoryList(Page<KeyPersonRatingHistory> page) {
        Map<String, Object> user = (Map<String, Object>) page.getParams().get("_user");
        if (user != null) {
            Map<String, String> pos = DataScopeUtil.getPosition(user);
            Map<String, Object> setMap = new HashMap<>();
            setMap.put("scope_grade", pos.get("grade"));
            setMap.put("scope_area_id", pos.get("area_id"));
            page.getParams().put("_scope", setMap);
        }
        Page<KeyPersonRatingHistory> keyPersonRatingHistoryPageList = commonService.findPage(namespace + "selectRatingHistoryList", page);
        return keyPersonRatingHistoryPageList;
    }

    @ApiOperation(value = "导入人员信息", desc = "导入人员信息")
    public Map<String, Object> importExcel(Map<String, Object> map, MultipartFile file) {
        Map<String, Object> result = new HashMap<>();
        try {
            if("3".equals(map.get("sysType"))) {
                FileData3Listener listener = new FileData3Listener(commonService, namespace, map);
                EasyExcel.read(file.getInputStream(), KeyPerson3Imp.class, listener).sheet().headRowNumber(2).doRead();
                result = listener.getResult();
            }else{
                FileDataListener listener = new FileDataListener(commonService, namespace, map);
                EasyExcel.read(file.getInputStream(), KeyPersonImp.class, listener).sheet().headRowNumber(2).doRead();
                result = listener.getResult();
            }
        } catch (IOException e) {
            throw new CustomException("导入失败");
        }

        return result;
    }

    @ApiOperation(value = "导入模板下载", desc = "导入模板下载")
    public void templateDownload(Map<String, Object> map, HttpServletResponse response) {
        response.setContentType("application/application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        try {
            String fileName = URLEncoder.encode("未成年人导入模板", "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            response.setHeader("filename", fileName + ".xlsx");
            response.setHeader("Access-Control-Expose-Headers", "filename,Content-Disposition");

            String pdfFilePath = "keyPersonImp.xlsx";
            if("3".equals(map.get("sysType"))) {
                pdfFilePath = "keyPerson3Imp.xlsx";
            }
            Resource resource = new ClassPathResource(pdfFilePath);
            InputStream is = resource.getInputStream();
            ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream()).withTemplate(is).excelType(ExcelTypeEnum.XLSX).build();
            excelWriter.finish();
        } catch (Exception e) {
            log.error("下载模版异常", e);
        }
    }
}
