package com.scpyun.platform.jilinsscgsdp.check;

import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @Author liu
 * @Date 2024/5/31 14:42
 * @PackageName:com.scpyun.platform.jilinsscgsdp.utils
 * @ClassName: EventCheckUtils
 * @Description: TODO
 * @Version 1.0
 */
public class EventCheckUtils {

    /**
     * 事件上报校验参数
     * @param map
     * @return
     */
    public static List<Map<String, Object>> eventCheck(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("event_type"))){
            throw new CustomException("事件类别不可为空！");
        }
        if (StringUtils.isEmpty(map.get("event_source"))){
            throw new CustomException("事件来源不可为空！");
        }
        if (StringUtils.isEmpty(map.get("event_category_id"))){
            throw new CustomException("纠纷类别不可为空！");
        }
        if (StringUtils.isEmpty(map.get("event_type_id"))){
            throw new CustomException("纠纷类别不可为空！");
        }
        if (StringUtils.isEmpty(map.get("userList"))){
            throw new CustomException("当事人不可为空！");
        }
        List<Map<String, Object>> userList = (List<Map<String, Object>>) map.get("userList");
        if (CollectionUtils.isEmpty(userList)){
            throw new CustomException("当事人不可为空！");
        }
        return userList;
    }

    /**
     * 事件修改校验参数
     * @param map
     */
    public static void eventUpdateCheck(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("eventMap"))){
            throw new CustomException("事件不可为空！");
        }
        if (StringUtils.isEmpty(map.get("eventFlowLogMap"))){
            throw new CustomException("事件rizhi不可为空！");
        }
        if (StringUtils.isEmpty(map.get("userList"))){
            throw new CustomException("当事人不可为空！");
        }
        List<Map<String, Object>> userList = (List<Map<String, Object>>) map.get("userList");
        if (CollectionUtils.isEmpty(userList)){
            throw new CustomException("当事人不可为空！");
        }
    }
}
