//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.scpyun.platform.jilinsscgsdp.utils;

import com.scpyun.base.core.utils.StringUtils;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

import java.util.HashMap;
import java.util.Map;
/**
 *
 * @Title:  RedisConfig
 * @Package RedisConfig.java
 * @Description: copy By scp-grid
 * @author:  guojiucoder
 * @date:   2024/7/31 14:25
 * @version V1.0.0
 *
 */
public class RedisConfig {
    private int port;
    private String passWord;
    private String templatehosts;
    private int maxIdl;
    private int minIdl = 20;
    private int database = 0;
    public int redisCount = 0;
    public static Map<String, RedisTemplate<String, Object>> redisTemplateMap = new HashMap();

    public RedisConfig() {
    }

    public void init() throws Exception {
        if (!StringUtils.isEmpty(this.templatehosts)) {
            String[] templatehostsArr = this.templatehosts.split(",");
            this.redisCount = templatehostsArr.length;
            String[] var2 = templatehostsArr;
            int var3 = templatehostsArr.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                String templatehosts = var2[var4];
                String[] templateArr = templatehosts.split("_");
                redisTemplateMap.put(templateArr[0], this.redisTemplateObject(templateArr[1], Integer.valueOf(templateArr[2])));
            }

        }
    }

    public RedisTemplate<String, Object> redisTemplateObject(String host, int post) throws Exception {
        RedisTemplate<String, Object> template = new RedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory(host, post));
        this.setSerializer(template);
        template.afterPropertiesSet();
        return template;
    }

    public RedisConnectionFactory redisConnectionFactory(String host, int post) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(this.maxIdl);
        poolConfig.setMinIdle(this.minIdl);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setNumTestsPerEvictionRun(10);
        poolConfig.setTimeBetweenEvictionRunsMillis(60000L);
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(poolConfig);
        jedisConnectionFactory.setHostName(host);
        if (!this.passWord.isEmpty()) {
            jedisConnectionFactory.setPassword(this.passWord);
        }

        jedisConnectionFactory.setPort(post);
        jedisConnectionFactory.setDatabase(this.database);
        jedisConnectionFactory.afterPropertiesSet();
        return jedisConnectionFactory;
    }

    private void setSerializer(RedisTemplate<String, Object> template) {
        RedisSerializer<String> stringSerializer = new StringRedisSerializer();
        template.setKeySerializer(stringSerializer);
        template.setValueSerializer(stringSerializer);
        template.setHashKeySerializer(stringSerializer);
        template.setHashValueSerializer(stringSerializer);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getTemplatehosts() {
        return this.templatehosts;
    }

    public void setTemplatehosts(String templatehosts) {
        this.templatehosts = templatehosts;
    }

    public int getMaxIdl() {
        return this.maxIdl;
    }

    public void setMaxIdl(int maxIdl) {
        this.maxIdl = maxIdl;
    }
}
