package com.scpyun.platform.jilinsscgsdp.bean.vo.task;


import com.scpyun.platform.jilinsscgsdp.annotation.IdCard;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

public class ReqKeyPersonVo extends ReqBaseVo{

    @NotEmpty(message = "id不可为空", groups = {Insert.class, Update.class})
    private String id;
    @NotEmpty(message = "姓名不可为空", groups = {Insert.class, Update.class})
    private String name;
    /**
     * 重点人员类别（
     * 刑满释放人员==2，
     * 严重精神障碍患者==3，
     * 涉重点信访事项人员==4，
     * 涉重点涉法涉诉类人员==5，
     * “三失一偏”人员==1）
     */
    private String sysType;
    @NotEmpty(message = "证件号不可为空", groups = {Insert.class, Update.class})
    @IdCard
    private String cardNo;
    @NotEmpty(message = "户籍所在地不可为空", groups = {Insert.class, Update.class})
    private String registeredResidence;
    @NotEmpty(message = "联系电话不可为空", groups = {Insert.class, Update.class})
    private String phone;
    @NotEmpty(message = "责任单位（安置帮教）不可为空", groups = {Insert.class, Update.class})
    private String responsibleCompanyByAssistance;
    @NotEmpty(message = "责任人（安置帮教）不可为空", groups = {Insert.class, Update.class})
    private String responsiblePersonByAssistance;
    @NotEmpty(message = "责任单位（重点人员）不可为空", groups = {Insert.class, Update.class})
    private String responsibleCompanyByKeyPersonnel;
    @NotEmpty(message = "责任人（重点人员）不可为空", groups = {Insert.class, Update.class})
    private String responsiblePersonKeyPersonnel;
    private String responsiblePerson;
    private String responsibleCompany;
    @NotEmpty(message = "性别不可为空", groups = {Insert.class, Update.class})
    private String sex;
    @NotEmpty(message = "现住址不可为空", groups = {Insert.class, Update.class})
    private String address;
    @NotEmpty(message = "有无重新犯罪倾向不可为空", groups = {Insert.class, Update.class})
    private String criminalTendency;
    private String criminalTendencySituation;
    private String lettersVisitsType;
    @NotEmpty(message = "民族不可为空")
    private String folk;
    private String relatedPersonName;
    private String relatedPersonRelation;
    private String relatedPersonPhone;
    private String relatedPersonAddress;
    private String controlCompanySupervisor;
    private String controlCompanySupervisorPerson;
    private String riskLevel;
    @NotEmpty(message = "是否涉及矛盾纠纷不可为空", groups = {Insert.class, Update.class})
    private String involvingConflictsDisputes;
    private String createDate;
    private String updateDate;
    private String createUser;
    private String updateUser;
    @NotEmpty(message = "地区不可为空", groups = {Insert.class, Update.class})
    private String region;
    @NotEmpty(message = "市编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "市编码格式异常", groups = {Insert.class, Update.class})
    private String cityCode;

    /**
     * 区编码
     */
    @NotEmpty(message = "区编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "区编码格式异常", groups = {Insert.class, Update.class})
    private String areaCode;

    /**
     * 街道编码
     */
    @NotEmpty(message = "街道不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "街道编码格式异常", groups = {Insert.class, Update.class})
    private String streetCode;

    /**
     * 社区编码
     */
    @NotEmpty(message = "社区不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "社区编码格式异常", groups = {Insert.class, Update.class})
    private String communityCode;
    private String remarks;
    private String hazardAssessmentLevel;
    @NotEmpty(message = "appid不可为空", groups = {Insert.class, Update.class})
    private String appid;
    /**
     * 添加状态
     */
    private String type;
    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;
    private String dockingId;

    private Integer intId;

    public Integer getIntId() {
        return intId;
    }

    public void setIntId(Integer intId) {
        this.intId = intId;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getCommunityCode() {
        return communityCode;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


    public String getSysType() {
        return sysType;
    }

    public void setSysType(String sysType) {
        this.sysType = sysType;
    }


    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }


    public String getRegisteredResidence() {
        return registeredResidence;
    }

    public void setRegisteredResidence(String registeredResidence) {
        this.registeredResidence = registeredResidence;
    }


    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }


    public String getResponsibleCompanyByAssistance() {
        return responsibleCompanyByAssistance;
    }

    public void setResponsibleCompanyByAssistance(String responsibleCompanyByAssistance) {
        this.responsibleCompanyByAssistance = responsibleCompanyByAssistance;
    }


    public String getResponsiblePersonByAssistance() {
        return responsiblePersonByAssistance;
    }

    public void setResponsiblePersonByAssistance(String responsiblePersonByAssistance) {
        this.responsiblePersonByAssistance = responsiblePersonByAssistance;
    }


    public String getResponsibleCompanyByKeyPersonnel() {
        return responsibleCompanyByKeyPersonnel;
    }

    public void setResponsibleCompanyByKeyPersonnel(String responsibleCompanyByKeyPersonnel) {
        this.responsibleCompanyByKeyPersonnel = responsibleCompanyByKeyPersonnel;
    }


    public String getResponsiblePersonKeyPersonnel() {
        return responsiblePersonKeyPersonnel;
    }

    public void setResponsiblePersonKeyPersonnel(String responsiblePersonKeyPersonnel) {
        this.responsiblePersonKeyPersonnel = responsiblePersonKeyPersonnel;
    }


    public String getResponsiblePerson() {
        return responsiblePerson;
    }

    public void setResponsiblePerson(String responsiblePerson) {
        this.responsiblePerson = responsiblePerson;
    }


    public String getResponsibleCompany() {
        return responsibleCompany;
    }

    public void setResponsibleCompany(String responsibleCompany) {
        this.responsibleCompany = responsibleCompany;
    }


    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }


    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }


    public String getCriminalTendency() {
        return criminalTendency;
    }

    public void setCriminalTendency(String criminalTendency) {
        this.criminalTendency = criminalTendency;
    }


    public String getCriminalTendencySituation() {
        return criminalTendencySituation;
    }

    public void setCriminalTendencySituation(String criminalTendencySituation) {
        this.criminalTendencySituation = criminalTendencySituation;
    }


    public String getLettersVisitsType() {
        return lettersVisitsType;
    }

    public void setLettersVisitsType(String lettersVisitsType) {
        this.lettersVisitsType = lettersVisitsType;
    }


    public String getFolk() {
        return folk;
    }

    public void setFolk(String folk) {
        this.folk = folk;
    }


    public String getRelatedPersonName() {
        return relatedPersonName;
    }

    public void setRelatedPersonName(String relatedPersonName) {
        this.relatedPersonName = relatedPersonName;
    }


    public String getRelatedPersonRelation() {
        return relatedPersonRelation;
    }

    public void setRelatedPersonRelation(String relatedPersonRelation) {
        this.relatedPersonRelation = relatedPersonRelation;
    }


    public String getRelatedPersonPhone() {
        return relatedPersonPhone;
    }

    public void setRelatedPersonPhone(String relatedPersonPhone) {
        this.relatedPersonPhone = relatedPersonPhone;
    }


    public String getRelatedPersonAddress() {
        return relatedPersonAddress;
    }

    public void setRelatedPersonAddress(String relatedPersonAddress) {
        this.relatedPersonAddress = relatedPersonAddress;
    }


    public String getControlCompanySupervisor() {
        return controlCompanySupervisor;
    }

    public void setControlCompanySupervisor(String controlCompanySupervisor) {
        this.controlCompanySupervisor = controlCompanySupervisor;
    }


    public String getControlCompanySupervisorPerson() {
        return controlCompanySupervisorPerson;
    }

    public void setControlCompanySupervisorPerson(String controlCompanySupervisorPerson) {
        this.controlCompanySupervisorPerson = controlCompanySupervisorPerson;
    }


    public String getRiskLevel() {
        return riskLevel;
    }

    public void setRiskLevel(String riskLevel) {
        this.riskLevel = riskLevel;
    }


    public String getInvolvingConflictsDisputes() {
        return involvingConflictsDisputes;
    }

    public void setInvolvingConflictsDisputes(String involvingConflictsDisputes) {
        this.involvingConflictsDisputes = involvingConflictsDisputes;
    }


    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }


    public String getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }


    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }


    public String getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }


    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }


    public String getHazardAssessmentLevel() {
        return hazardAssessmentLevel;
    }

    public void setHazardAssessmentLevel(String hazardAssessmentLevel) {
        this.hazardAssessmentLevel = hazardAssessmentLevel;
    }

}
