package com.scpyun.platform.jilinsscgsdp.bean.vo.task;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;

/**
 * @Author liu
 * @Date 2024/10/15 13:21
 * @PackageName:com.scpyun.platform.jilinexchange.bean.vo
 * @ClassName: ReqFocusGroupVo
 * @Description: TODO
 * @Version 1.0
 */
public class ReqFocusGroupVo extends ReqBaseVo{
	
    /**
     * 主键
     */
    @NotEmpty(message = "id不可为空",groups = {Insert.class,Update.class,Delete.class})
    @Length(min=1, max=200,message = "id数据长度范围1到200",groups = {Insert.class,Update.class,Delete.class})
    private String id;
    
    /**
     * 证件号
     */
    @NotEmpty(message = "证件号不可为空")
    @Length(min=1, max=100,message = "证件号数据长度范围1到100",groups = {Insert.class,Update.class})
    private String cardno;

    /**
     * 标签id
     */
    @NotEmpty(message = "标签id不可为空")
    @Length(min=1, max=36,message = "标签数据长度范围1到36",groups = {Insert.class,Update.class})
    private String lableId;
    
    /**
     * appid
     */
    @NotEmpty(message = "appid不可为空")
    @Length(min=1, max=36,message = "appid数据长度范围1到36",groups = {Insert.class,Delete.class})
    private String appid;

    /**
     * 证件类别
     */
    private String cardType;

    /**
     * 添加状态
     */
    private String type;

    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;
    
    private String dockingId;
    
    public String getDockingId() {
		return dockingId;
	}

	public void setDockingId(String dockingId) {
		this.dockingId = dockingId;
	}

	public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLableId() {
        return lableId;
    }

    public void setLableId(String lableId) {
        this.lableId = lableId;
    }

    public String getCardno() {
        return cardno;
    }

    public void setCardno(String cardno) {
        this.cardno = cardno;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
}
