package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.core.utils.UUIDUtil;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.DisputeResolution;
import com.scpyun.platform.jilinsscgsdp.bean.entity.DisputeResolutionFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;


@Api("调解管理")
@Service("DisputeResolution")
public class DisputeResolutionServiceImpl {

    @Autowired
    CommonService commonService;
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.disputeresolution.";

    @Autowired
    UploadServiceImpl uploadService;

    @ApiOperation(value = "")
    public Page<DisputeResolution> selectDisputeResolutionList(Page page) {
        Page<DisputeResolution> page1 = commonService.findPage(nameSpace + "selectDisputeResolutionList", page);
        page1.getResults().forEach(item -> {
            item.setFiles(commonService.findList(nameSpace + "selectDisputeResolutionFilesList", item));
        });
        return page1;
    }

    @ApiOperation(value = "")
    public Object deleteDisputeResolutionById(DisputeResolution disputeResolution) {
        if (StringUtils.isEmpty(disputeResolution.getId())) {
            throw new CustomException("缺少参数！id");
        }
        return commonService.update(nameSpace + "deleteDisputeResolutionById", disputeResolution);
    }

    @ApiOperation(value = "")
    public Object insertDisputeResolution(DisputeResolution disputeResolution) {
        String id = UUIDUtil.getUUID();
        disputeResolution.setId(id);
        try {
            commonService.insert(nameSpace + "insertDisputeResolution", disputeResolution);
                for (DisputeResolutionFile file : disputeResolution.getFiles()) {
                    file.set_user(disputeResolution.get_user());
                    file.setJlDisputeResolutionId(id);
                    file.setId(UUIDUtil.getUUID());
                    Map<String, Object> map = new HashMap<>();
                    map.put("business_type", "insertDisputeResolution");
                    /*if ("1".equals(disputeResolution.getCaseBase())) {
                        if (StringUtils.isNotEmpty(file.getBase64())) {
                            map = uploadService.uploadFileForInputStream(map, file.getBase64(), file.getFileName());
                            file.setObsKey(map.get("uuid").toString());
                            file.setFileName(map.get("originalFilename").toString());
                            file.setFileUrl((String) map.get("url"));
                        }
                    }*/
                    commonService.insert(nameSpace + "insertDisputeResolutionFiles", file);
                }
        } catch (Exception e) {
            throw new CustomException(e.getMessage(), e);
        }
        return "success";
    }

    @ApiOperation(value = "")
    public Object updateDisputeResolution(DisputeResolution disputeResolution) {
        try {
            commonService.update(nameSpace + "updateDisputeResolution", disputeResolution);
            commonService.delete(nameSpace + "updateDisputeResolutionFiles", disputeResolution);
            for (DisputeResolutionFile file : disputeResolution.getFiles()) {
                file.set_user(disputeResolution.get_user());
                file.setJlDisputeResolutionId(disputeResolution.getId());
                file.setId(UUIDUtil.getUUID());
                Map<String, Object> map = new HashMap<>();
                map.put("business_type", "insertDisputeResolution");
                if (StringUtils.isNotEmpty(file.getBase64())) {
                    map = uploadService.uploadFileForInputStream(map, file.getBase64(), file.getFileName());
                    file.setObsKey(map.get("uuid").toString());
                    file.setFileName(map.get("originalFilename").toString());
                }
                commonService.insert(nameSpace + "insertDisputeResolutionFiles", file);
            }
        } catch (Exception e) {
            throw new CustomException(e.getMessage(), e);
        }
        return "success";
    }


}
