package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.FollowUpRecords;
import com.scpyun.platform.jilinsscgsdp.bean.entity.FollowUpRecordsFiles;
import com.scpyun.platform.jilinsscgsdp.bean.vo.EventApproveVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Api("事件申请及审批相关接口")
@Service("EventApproveServiceImpl")
public class EventApproveServiceImpl {

    @Autowired
    CommonService commonService;
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.eventApprove.";

    @ApiOperation(value = "申请操作", desc = "申请操作")
    public void insertEventApprove(EventApproveVo eventApproveVo) {
        String company_grade = eventApproveVo.get_user().getCompany_grade();
        switch (company_grade){
            case "6":// 社区、网格员
                eventApproveVo.setDeal_user(eventApproveVo.get_user().getParent_id());
                break;
            case "5":// 街道
            case "4":// 区
            case "3":// 市
                // 判断账号是否是横向部门
                String fax = commonService.getObject(nameSpace + "getFax", eventApproveVo.get_user().getCompany_id());
                if(StringUtils.isNotEmpty(fax)){// 是横向部门
                    // 获取该横向部门所属的综治中心
                    String office_id = commonService.getObject(nameSpace+"getOfficeId",eventApproveVo.get_user().getCompany_id());
                    eventApproveVo.setDeal_user(office_id);
                }else{
                    eventApproveVo.setDeal_user(eventApproveVo.get_user().getParent_id());
                }
                break;
            default:
                eventApproveVo.setDeal_user(eventApproveVo.get_user().getCompany_id());
        }
        commonService.insert(nameSpace+"insertEventApprove",eventApproveVo);
    }

    @ApiOperation(value = "审批操作", desc = "审批操作")
    public void updateEventApprove(EventApproveVo eventApproveVo) {
        commonService.update(nameSpace+"updateEventApprove",eventApproveVo);
    }

    @ApiOperation(value = "申请、审批列表")
    public List<EventApproveVo> eventApproveList(EventApproveVo eventApproveVo) {
        return commonService.findList(nameSpace+"eventApproveList",eventApproveVo);
    }




}