package com.scpyun.platform.jilinsscgsdp.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventAttachInsertVo;
import com.scpyun.platform.jilinsscgsdp.constant.NotesConstant;
import com.scpyun.platform.jilinsscgsdp.constant.NumberConstant;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.util.HtmlUtils;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.base.utils.UUIDUtil;
import com.scpyun.platform.jilinsscgsdp.constant.Constant;

import javax.validation.Valid;

@Api(value = "APP公告")
@Service("noticeService")
public class NoticeServiceImpl {

    @Autowired
    private CommonService commonService;
    
    @ApiOperation(value = "新增")
    public String insertData(Map<String,Object> map) {
        String uuid=UUIDUtil.getUUID();
		map.put("uuid", uuid);
		map.put("context", HtmlUtils.htmlEscapeHex((String) map.get("context")));
        if(map.get("urlList")!=null && JSONArray.parseArray(map.get("urlList").toString()).size()>0){
            List<Map<String,Object>> urlList = (List<Map<String, Object>>) map.get("urlList");
            for (Map<String, Object> item : urlList) {
                item.put("notice_id",uuid);
                commonService.insert(Constant.NAMESPACE_NOTICE + "insertNoticeAttach", item);
            }
        }
		int insert = commonService.insert(Constant.NAMESPACE_NOTICE + "insertData", map);
        return insert > 0 ? "操作成功" : "操作失败";
    }

    @ApiOperation(value = "删除")
    public String updateDelData(Map<String,Object> map) {
        int delete = commonService.delete(Constant.NAMESPACE_NOTICE + "removeData", map);
        return delete > 0 ? "操作成功" : "操作失败";
    }

    @ApiOperation(value = "更新")
    public String updateData(Map<String,Object> map) {
    	int update = 0;
		if(map.get("context") != null) {
			map.put("context", HtmlUtils.htmlEscapeHex((String) map.get("context")));
		}
		if(map.get("publish_status")==null) {
			map.put("publish_status","0");
		}
		update = commonService.update(Constant.NAMESPACE_NOTICE + "updateData", map);
        // 先清除附件
        commonService.update(Constant.NAMESPACE_NOTICE +"clearNoticeAttach",map);
        if(map.get("urlList")!=null && JSONArray.parseArray(map.get("urlList").toString()).size()>0){
            List<Map<String,Object>> urlList = (List<Map<String, Object>>) map.get("urlList");
            for (Map<String, Object> item : urlList) {
                item.put("notice_id",map.get("id"));
                commonService.insert(Constant.NAMESPACE_NOTICE + "insertNoticeAttach", item);
            }
        }
        return update > 0 ? "操作成功" : "操作失败";
    }

    @ApiOperation(value = "查询详情")
    public Map<String, Object> getObject(Map<String,Object> map) {
    	Map<String, Object> obj = commonService.getObject(Constant.NAMESPACE_NOTICE + "getObject", map);
    	obj.put("context", HtmlUtils.htmlUnescape((String) obj.get("context")));
        return obj;
    }

    @ApiOperation(value = "查询分页列表")
    public Page<Map<String, Object>> selectListPage(Page<Map<String, Object>> mapPage) {
    	Page<Map<String, Object>> ret = commonService.findPage(Constant.NAMESPACE_NOTICE + "selectListPage", mapPage);
    	List<Map<String, Object>> result = ret.getResults();
    	if(result.size() > 0) {
    		for (Map<String, Object> map : result) {
    			map.put("context", HtmlUtils.htmlUnescape((String) map.get("context")));
    		}
    	}
        return ret;
    }
    
    @ApiOperation(value = "查询列表")
    public List<Map<String, Object>> selectList(Map<String,Object> map) {
    	List<Map<String, Object>> ret = new ArrayList<>();
    	ret = commonService.findList(Constant.NAMESPACE_NOTICE + "selectList", map);
    	ret.stream().forEach(m->{
    		if(m.get("context") != null) {
    			m.put("context", HtmlUtils.htmlEscapeHex((String) m.get("context")));
    		}
    	});
        return ret;
    }
}
