package com.scpyun.platform.jilinsscgsdp.utils;

import com.alibaba.fastjson.JSONObject;
import com.scpyun.base.db.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public class DataScopeUtil {
    public static final String TYPE_RUCS = "2"; // 刑满释放
    public static final String TYPE_PSMD = "3"; // 严重精神障碍患者
    public static final String TYPE_KM = "6"; // 重点未成年人

    private static CommonService commonService;
    private static String namespace = "com.scpyun.platform.standard.jilinsscgsdp.KeyPersonPower.";
    /**
     * 获取按钮权限
     * @param _user
     * @return  有权限即返回按钮  具体查看 dic type == "page_button" ，返回 key：按钮标识   value：按钮描述
     * 目前的按钮有：
     * rucs_rating：刑满释放人员 - 评分按钮
     * psmd_rating：严重精神障碍患者 - 评分按钮
     * km_rating：重点未成年人员 - 评分按钮
     * rucs_visit：刑满释放人员 - 回访按钮
     * psmd_visit：严重精神障碍患者 - 回访按钮
     * km_visit：重点未成年人员 - 回访按钮
     */
    public static Map<String, String> getButtonPower(Object _user) {
        Map<String, String> resultMap = new HashMap<>();
        Map<String, Object> params = new HashMap<>();
        JSONObject user = JSONObject.parseObject(JSONObject.toJSONString(_user));
        String companyName = user.getString("company_name");
        params.put("conpanyName", companyName);

        List<Map<String, Object>> resultList = commonService.findList(namespace + "selectPower", params);
        for(Map<String, Object> result : resultList) {
            String[] officeNameArray = result.get("rating_visit_office").toString().split(",");
            for(String officeName : officeNameArray) {
                if(companyName.contains(officeName)) {
                    resultMap.put(result.get("rating_dict_value").toString(), result.get("rating_dict_label").toString());
                    break;
                }
            }
        }

        if ("admin".equals(user.getString("no"))) {
            params.put("type", "page_button");
            List<Map<String, Object>> all = commonService.findList(namespace + "selectDicByType", params);
            for(Map<String, Object> key: all ) {
                resultMap.put(key.get("value").toString(), key.get("label").toString());
            }
        }

        return resultMap;
    }

    /**
     * 获取当前用户组织机构区域信息
     * @param _user
     * @return
     * grade: grade=0:总机构、grade=2:吉林省 对应字段 region  、grade=3:市 对应字段 city_id、grade=4:区县 对应字段 area_id、grade=5:街道 对应字段 street_id、grade=6:社区、村 对应字段 community_id
     * area_id: 区域id
     */
    public static Map<String, String> getPosition(Object _user) {
        Map queryMap = new HashMap();
        Map resultMap = new HashMap();

        JSONObject user = JSONObject.parseObject(JSONObject.toJSONString(_user));
        String company_id = user.getString("company_id");
        // 机构等级(grade=0:总机构、grade=2:吉林省、grade=3:市、grade=4:区县、grade=5:街道、grade=6:社区、村)
        String company_grade = user.getString("company_grade");

        queryMap.put("id", company_id);
        //
        Map<String, Object> result = commonService.getObject(namespace + "selectOfficeById", queryMap);

        resultMap.put("grade", company_grade);
        resultMap.put("area_id", result.get("area_id"));

        return resultMap;
    }

    /**
     * 是否是长春
     * @param _user
     * @return true:是  false：否
     */
    public static Boolean isChanChun(Object _user) {
        Map queryMap = new HashMap();
        JSONObject user = JSONObject.parseObject(JSONObject.toJSONString(_user));
        String company_id = user.getString("company_id");
        if (company_id.length() == 12 && company_id.startsWith("2201")) {
            return true;
        } else if (company_id.length() == 12){
            return false;
        } else {
            queryMap.put("id", company_id);
            Map<String, Object> result = commonService.getObject(namespace + "selectOfficeById", queryMap);
            String area_id = result.get("area_id").toString();
            if (area_id.startsWith("2201")) {
                return true;
            } else {
                return false;
            }
        }
    }

    public static Map<String, Object> resetUser(Map<String, Object> map) {
        Object _user = map.get("_user");
        Map queryMap = new HashMap();
        JSONObject user = JSONObject.parseObject(JSONObject.toJSONString(_user));
        String company_id = user.getString("company_id");
        if (company_id.length() == 12) {
            user.put("area_id", company_id);
            map.put("_user", user);
            return map;
        }

        queryMap.put("id", company_id);
        Map<String, Object> result = commonService.getObject(namespace + "selectOfficeById", queryMap);
        String id = result.get("id").toString();
        String area_id = result.get("area_id").toString();
        user.put("area_id", area_id);
        map.put("_user", user);
        return map;
    }


    public static CommonService getCommonService() {
        return commonService;
    }

    @Autowired
    public void setCommonService(CommonService commonService) {
        DataScopeUtil.commonService = commonService;
    }
}
