package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.ConflictWarning;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Api("矛盾预警管理")
@Service("ConflictWarningManagement")
public class ConflictWarningManagementServiceImpl {

    @Autowired
    CommonService commonService;
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.conflictwarning.";


    @ApiOperation(value = "")
    public List<ConflictWarning> selectConflictWarningList(ConflictWarning conflictWarning) {
        return commonService.findList(nameSpace + "selectConflictWarningList", conflictWarning);
    }

    @ApiOperation(value = "")
    public Object updateConflictWarning(ConflictWarning list) {
        return commonService.update(nameSpace + "updateConflictWarning", list);
    }





}
