package com.scpyun.base.core.utils.timer.log4mongo;

import com.scpyun.base.core.utils.Global;
import com.scpyun.base.core.utils.StringUtils;

import java.util.Properties;

public class Log4jProperties {

	public static Properties getLog4jProperties() {

		Properties properties = new Properties();
		String unifylogMongoDBStr = "";
		String tasklogMongoDBStr = "";
		String logLevelStr = "info";
		if(StringUtils.isNotEmpty(Global.getConfig("scp.log.mongo.ip"))){
			unifylogMongoDBStr = ", unifylogMongoDB";
			tasklogMongoDBStr = ", tasklogMongoDB";
		}
		if("close".equals(Global.getConfig("scp.log"))) {
			return properties;
		}else if("debug".equals(Global.getConfig("scp.log"))){
			logLevelStr = "debug";
		}else if(!StringUtils.isEmpty(Global.getConfig("scp.log"))){
			logLevelStr = Global.getConfig("scp.log");
		}
		String hostName = System.getProperty("hostname");
		String hostNameID = "";
		if(!StringUtils.isEmpty(hostName)){
			hostNameID = "-" + hostName.substring(hostName.lastIndexOf("-") + 1);
		}
		
		
		// # Set root logger level to Debug and its only appender to A1
		properties.setProperty("log4j.rootLogger", logLevelStr+", A1");
		properties.setProperty("log4j.category.org.springframework", logLevelStr);
		// MyBatis 与 JDBC 分类日志（便于在控制台打印 SQL）
		properties.setProperty("log4j.logger.org.apache.ibatis", logLevelStr);
		properties.setProperty("log4j.logger.org.mybatis", logLevelStr);
		properties.setProperty("log4j.logger.java.sql", logLevelStr);
		properties.setProperty("log4j.logger.jdbc.sqlonly", logLevelStr);

		// #custom log write
		properties.setProperty("log4j.logger.unifylog", logLevelStr+", unifylogfile" + unifylogMongoDBStr);
		properties.setProperty("log4j.additivity.unifylog", "false");
		properties.setProperty("log4j.logger.tasklog", logLevelStr+", tasklogfile" + tasklogMongoDBStr);
		properties.setProperty("log4j.additivity.tasklog", "false");

		// # A1 is set to be ConsoleAppender
		properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
		properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
		properties.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d{yyyy-MM-dd HH:mm:ss} %p [%t] - %m%n");

		properties.setProperty("log4j.appender.tasklogfile", "org.apache.log4j.DailyRollingFileAppender");
		properties.setProperty("log4j.appender.tasklogfile.DatePattern", "'.'yyyy-MM-dd-a'.log'");
		properties.setProperty("log4j.appender.tasklogfile.File", "./logs/uid" + hostNameID);
		properties.setProperty("log4j.appender.tasklogfile.layout", "org.apache.log4j.PatternLayout");
		properties.setProperty("log4j.appender.tasklogfile.layout.ConversionPattern", "[%d{yyyy-MM-dd HH:mm:ss}][%p][%t] %x - %m%n");

		// #write file[unifylog]
//		properties.setProperty("#log4j.logger.unifylog", "debug, unifylog");
		properties.setProperty("log4j.appender.unifylogfile", "org.apache.log4j.DailyRollingFileAppender");
		properties.setProperty("log4j.appender.unifylogfile.DatePattern", "'.'yyyy-MM-dd-a'.log'");
		properties.setProperty("log4j.appender.unifylogfile.File", "./logs/unifylog" + hostNameID);
		properties.setProperty("log4j.appender.unifylogfile.layout", "org.apache.log4j.PatternLayout");
		properties.setProperty("log4j.appender.unifylogfile.layout.ConversionPattern", "[%d{yyyy-MM-dd HH:mm:ss.SSS}][%p][%t] %x - %m%n");

		if (StringUtils.isNotEmpty(Global.getConfig("scp.log.mongo.ip"))) {

			properties.setProperty("log4j.appender.tasklogMongoDB", "com.scpyun.base.core.utils.timer.log4mongo.CustomTaskMongoDbAppender");
			properties.setProperty("log4j.appender.tasklogMongoDB.hostname", Global.getConfig("scp.log.mongo.ip"));
			properties.setProperty("log4j.appender.tasklogMongoDB.port", StringUtils.isNotEmpty(Global.getConfig("scp.log.mongo.port")) ? Global.getConfig("scp.log.mongo.port") : "29807");
			// ## databaseName full name is db+'_[config.properties -->
			// server.enviro]'
			properties.setProperty("log4j.appender.tasklogMongoDB.databaseName", "taskdb");
			// ## collectionName is auto time, collectionName from
			// [config.properties --> server.id]
			properties.setProperty("log4j.appender.tasklogMongoDB.collectionName", "auto");

			properties.setProperty("log4j.appender.unifylogMongoDB", "com.scpyun.base.core.utils.timer.log4mongo.CustomMongoDbAppender");
			properties.setProperty("log4j.appender.unifylogMongoDB.hostname", Global.getConfig("scp.log.mongo.ip"));
			properties.setProperty("log4j.appender.unifylogMongoDB.port",
					StringUtils.isNotEmpty(Global.getConfig("scp.log.mongo.port")) ? Global.getConfig("scp.log.mongo.port") : "29807");
			// ## databaseName full name is db+'_[config.properties -->
			// server.enviro]'"
			properties.setProperty("log4j.appender.unifylogMongoDB.databaseName", "undb");
			// ## collectionName is auto time, collectionName from
			// [config.properties --> server.id]"
			properties.setProperty("log4j.appender.unifylogMongoDB.collectionName", "auto");
		}

		return properties;
	}
}
