package com.scpyun.platform.jilinsscgsdp.bean.vo.task;


import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

public class ReqHomicideSuspectVo extends ReqBaseVo {
    /**
     * id
     */
    @NotEmpty(message = "id不可为空", groups = {Insert.class, Update.class})
    private String id;

    /**
     * 命案id
     */
    @NotEmpty(message = "命案id不可为空", groups = {Insert.class, Update.class})
    private String homicideId;

    /**
     * 嫌疑人身份证号
     */
    @NotEmpty(message = "嫌疑人身份证号不可为空", groups = {Insert.class, Update.class})
    @Length(min = 15, max = 18, message = "嫌疑人证件号字符长度不可超过18", groups = {Insert.class, Update.class})
    private String suspectCardno;

    /**
     * 嫌疑人姓名
     */
    @NotEmpty(message = "嫌疑人姓名不可为空", groups = {Insert.class, Update.class})
    @Length(max = 50, message = "嫌疑人姓名字符长度不可超过50", groups = {Insert.class, Update.class})
    private String suspectName;

    /**
     * 地市对接id
     */
    private String dockingId;

    @NotEmpty(message = "appid不可为空", groups = {Insert.class, Update.class})
    private String appid;

    /**
     * 添加状态
     */
    private String type;

    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;

    /**
     * 是否重点人员  1:是 2:否
     */
    @NotEmpty(message = "是否重点人员不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-2]$", message = "是否重点人员值必须为1-2", groups = {Insert.class, Update.class})
    private String isKeyPersonnel;

    /**
     * 重点人员类型
     */
    @NotEmpty(message = "重点人员类型不可为空", groups = {Insert.class, Update.class})
    private String keyPersonnelType;

    /**
     * 性别 1男 2女
     */
    @NotEmpty(message = "性别不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-2]$", message = "性别值必须为1-2", groups = {Insert.class, Update.class})
    private String sex;

    /**
     * 出生日期
     */
    @NotEmpty(message = "出生日期不可为空", groups = {Insert.class, Update.class})
    private String birthday;

    /**
     * 教育程度 1:文盲 2:小学学历 3:初中学历 4:高中学历 5:专科学历 6:本科学历 7:硕士学历 8:博士学历 9:其他
     */
    @NotEmpty(message = "教育程度不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-9]$", message = "教育程度值必须为1-9", groups = {Insert.class, Update.class})
    private String eduLevel;

    /**
     * 职业情况 1:党政机关人员 2:企事业人员 3:退休人员 4:无业人员 5:农民 6:个体户	 7:务工人员 8:其他
     */
    @NotEmpty(message = "职业情况不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-8]$", message = "职业情况值必须为1-8", groups = {Insert.class, Update.class})
    private String careerSituation;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHomicideId() {
        return homicideId;
    }

    public void setHomicideId(String homicideId) {
        this.homicideId = homicideId;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getSuspectCardno() {
        return suspectCardno;
    }

    public void setSuspectCardno(String suspectCardno) {
        this.suspectCardno = suspectCardno;
    }

    public String getSuspectName() {
        return suspectName;
    }

    public void setSuspectName(String suspectName) {
        this.suspectName = suspectName;
    }

    public String getIsKeyPersonnel() {
        return isKeyPersonnel;
    }

    public void setIsKeyPersonnel(String isKeyPersonnel) {
        this.isKeyPersonnel = isKeyPersonnel;
    }

    public String getKeyPersonnelType() {
        return keyPersonnelType;
    }

    public void setKeyPersonnelType(String keyPersonnelType) {
        this.keyPersonnelType = keyPersonnelType;
    }

    public String getEduLevel() {
        return eduLevel;
    }

    public void setEduLevel(String eduLevel) {
        this.eduLevel = eduLevel;
    }

    public String getCareerSituation() {
        return careerSituation;
    }

    public void setCareerSituation(String careerSituation) {
        this.careerSituation = careerSituation;
    }
}
