package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.KeyPerson;
import com.scpyun.platform.jilinsscgsdp.bean.entity.KeyPersonRatingHistory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Author liu
 * @Date 2025/9/25 16:50
 * @PackageName:com.scpyun.platform.jilinsscgsdp.service.impl
 * @ClassName: KeyPersonRating
 * @Description: TODO
 * @Version 1.0
 */
@Api("评分历史功能")
@Service("keyPersonRatingHistoryService")
public class KeyPersonRatingHistoryServiceImpl {
    @Autowired
    CommonService commonService;

    private final String SUCCESS = "success";

    private String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyPersonRatingHistory.";

    @ApiOperation(value = "查询评分历史列表", desc = "查询评分历史列表")
    public Page<KeyPersonRatingHistory> selectRatingHistoryList(Page<KeyPersonRatingHistory> page) {
        Page<KeyPersonRatingHistory> keyPersonRatingHistoryPageList = commonService.findPage(namespace + "selectRatingHistoryList", page);
        return keyPersonRatingHistoryPageList;
    }
}
