package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.alibaba.fastjson.JSON;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.utils.LngLonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
/**
 *
 * @Title:  GridChangeZBXServiceImpl
 * @Package GridChangeZBXServiceImpl.java
 * @Description: copy By scp-grid
 * @author:  guojiucoder
 * @date:   2024/7/31 14:09
 * @version V1.0.0
 *
 */
@Api("网格坐标系转换")
@Service("gridChangeZBXService")
public class GridChangeZBXServiceImpl {
	@Autowired
	private CommonService commonService;

	/**
	 * (高德转宏图)高德转84 适用于数据如下
	 * [[123.483839,41.835172],[123.482758,41.835644],[123.482669,41.835472],[123.481669,41.835773],[123.481463,41.835389]]
	 */
    public static String gcj02_To_Gps84_array(String array ){
		if(!array.startsWith("[[") || !array.endsWith("]]")) {
			return "格式错误";
		}
	    double[][] zbx = JSON.parseObject(array, double[][].class);
		for (int i = 0; i < zbx.length; i++) {
			double[] zbx_change = LngLonUtil.gcj02_To_Gps84(zbx[i][1],zbx[i][0]);
			zbx[i][0] = zbx_change[0];
			zbx[i][1] = zbx_change[1];
		}
		return JSON.toJSONString(zbx);
	}

	/**
	 *  (宏图转高德)
	 * @param array
	 * @return
	 */
	public static String Gps84_To_gcj02_array(String array ){
		if(!array.startsWith("[[") || !array.endsWith("]]")) {
			return "格式错误";
		}
		double[][] zbx = JSON.parseObject(array, double[][].class);
		for (int i = 0; i < zbx.length; i++) {
			double[] zbx_change = LngLonUtil.gps84_To_Gcj02(zbx[i][0],zbx[i][1]);
//					LngLonUtil.gcj02_To_Gps84(zbx[i][1],zbx[i][0]);
			zbx[i][1] = zbx_change[0];
			zbx[i][0] = zbx_change[1];
		}
		return JSON.toJSONString(zbx);
	}
    /**
	 * (高德转宏图)高德转84 适用于数据如下
	 * 123.483839,41.835172
	 */
    public static String gcj02_To_Gps84_string(String string ){
    	String zbx[] = string.split(",");
		if(zbx.length != 2) {
			return "格式错误";
		}
		double[] zbx_change = LngLonUtil.gcj02_To_Gps84(Double.parseDouble(zbx[1]),Double.parseDouble(zbx[0]));
		
		return String.valueOf(zbx_change[0])+","+String.valueOf(zbx_change[1]);
	}
	/**
	 *  (宏图转高德)
	 * @param string
	 * @return
	 */
	public static String Gps84_To_gcj02_string(String string ){
		String[] zbx = string.split(",");
		if(zbx.length != 2) {
			return "格式错误";
		}
		double[] zbx_change = LngLonUtil.gps84_To_Gcj02(Double.parseDouble(zbx[0]),Double.parseDouble(zbx[1]));
		return String.valueOf(zbx_change[1])+","+String.valueOf(zbx_change[0]);
	}
	
	/**
	 * 坐标数组保留六位小数 适用于数据如下
	 * [[41.79790460380813,122.72821679287668],[41.798125306120326,122.73455154599937]]
	 */
    public static String zbRound6_array(String array ){
		if(!array.startsWith("[[") || !array.endsWith("]]")) {
			return "格式错误";
		}
	    String[][] zbx = JSON.parseObject(array, String[][].class);
		for (int i = 0; i < zbx.length; i++) {
            String[] temp = zbx[i][0].split("\\.");
            if(temp.length == 1) 
            {

            	zbx[i][0] = zbx[i][0];
            }
            else if(temp.length == 2){
            	if(temp[1].length() < 6) {
            		zbx[i][0] = zbx[i][0];
            	}
            	else {
        			zbx[i][0] = zbx[i][0].substring(0,zbx[i][0].lastIndexOf("."))+zbx[i][0].substring(zbx[i][0].lastIndexOf("."),zbx[i][0].lastIndexOf(".")+7);
            	}
            }
            else {
            	zbx[i][0] = zbx[i][0];
            }
            temp = zbx[i][1].split("\\.");
            if(temp.length == 1) 
            {
            	zbx[i][1] = zbx[i][1];
            }
            else if(temp.length == 2){
            	if(temp[1].length() < 6) {
            		zbx[i][1] = zbx[i][1];
            	}
            	else {
        			zbx[i][1] = zbx[i][1].substring(0,zbx[i][1].lastIndexOf("."))+zbx[i][1].substring(zbx[i][1].lastIndexOf("."),zbx[i][1].lastIndexOf(".")+7);
            	}
            }
            else {
            	zbx[i][1] = zbx[i][1];
            }
            
		}
		return JSON.toJSONString(zbx).replace("\"", "");
	}

    /**
	 * 坐标数组保留六位小数 适用于数据如下
	 * 41.79790460380813,122.72821679287668
	 */
    public static String zbRound6_string(String string ){
    	String[] zbx = string.split(",");
		if(zbx.length != 2) {
			return "格式错误";
		}
		for (int i = 0;i< zbx.length;i++) {
			String[] temp = zbx[i].split("\\.");
			 if(temp.length == 1) 
	            {

	            	zbx[i] = zbx[i];
	            }
	            else if(temp.length == 2){
	            	if(temp[1].length() < 6) {
	            		zbx[i] = zbx[i];
	            	}
	            	else {
	        			zbx[i] = zbx[i].substring(0,zbx[i].lastIndexOf("."))+zbx[i].substring(zbx[i].lastIndexOf("."),zbx[i].lastIndexOf(".")+7);
	            	}
	            }
	            else {
	            	zbx[i] = zbx[i];
	            }
		}
		
		return zbx[0]+","+zbx[1];
    }


	public static void main(String[] args) {
		String array = "41.670597963961114,123.38483912178557";
		String arrays = "[[41.79790460380813,122.72821679287668],[41.798125306120326,122.73455154599937]]";
		String array1 = "[[41.797,122.72821679287668],[41.798125306120326,122.734]]";
		String array3 = "41.79790460380813,122.72821679287668";
		String array2 = "41.797,122.72821679287668";
		System.out.println("入参："+arrays);
		System.out.println("出参："+zbRound6_array(arrays));
		System.out.println("入参："+array1);
		System.out.println("出参："+zbRound6_array(array1));
		System.out.println("入参："+array3);
		System.out.println("出参："+zbRound6_string(array3));
		System.out.println("入参："+array2);
		System.out.println("出参："+zbRound6_string(array2));
//		System.out.println(Gps84_To_gcj02_string(array));
//		double x[] =LngLonUtil.gps84_To_Gcj02(41.67512288304322,123.45857475506176);
//		System.out.println(x[0]+","+x[1]);
	}

}
