package com.scpyun.platform.jilinsscgsdp.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.RandomUtil;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.core.utils.UUIDUtil;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqSysOfficeVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqSysUserVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.SysMenuVo;
import com.scpyun.platform.jilinsscgsdp.constant.NotesConstant;
import com.scpyun.platform.jilinsscgsdp.constant.NumberConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Api("初始化机构用户等")
@Service("SysInitServiceImpl")
public class SysInitServiceImpl {
    @Autowired
    CommonService commonService;
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.SysInitDao.";

    @ApiOperation(value = "初始化sys_area", desc = "初始化sys_area",nologin = true)
    public void insertInitSysArea(Map<String,Object> map) {
        List<Map<String,Object>> list = commonService.findList(nameSpace + "selectUcGovRegionInfo", map);
        int i=1;
        for (Map<String, Object> item : list) {
            i++;
            // 获取机构等级，并设置parent_ids
            if(item.get("region_lvl").equals("1")){// 国家
                item.put("parent_ids","-1");
            }else if(item.get("region_lvl").equals("2")){// 省级/部
                item.put("parent_ids","0");
            }else if(item.get("region_lvl").equals("3") || item.get("region_lvl").equals("4") || item.get("region_lvl").equals("5") || item.get("region_lvl").equals("6")){
                // 组装parent_ids
                Map<String,Object> res = commonService.getObject(nameSpace + "getParentIds", item);
                item.put("parent_ids",res.get("parent_ids"));
            }
            commonService.insert(nameSpace+"insertSysArea",item);
            System.out.println("===================="+i);
        }
    }

    @ApiOperation(value = "初始化sys_office、sys_suer、sys_user_role", desc = "初始化sys_office、sys_suer、sys_user_role")
    public void insertInitSysOffice(Map<String,Object> map) {
        Map<String,Object> user = (Map<String, Object>) map.get("_user");
        List<Map<String,Object>> getSysAreaList = commonService.findList(nameSpace + "getSysAreaList", map);
        int i=1;
        for (Map<String, Object> item : getSysAreaList) {
            i++;
            item.put("_user",user);
            // 插入sys_office
            item.put("grade",item.get("type"));
            item.put("area_id",item.get("id"));
            String code = commonService.getObject(nameSpace + "generateOfficeCode", map);
            item.put("code",code);
            if(item.get("type").equals("5")){ // 机构等级(type=1:吉林省、type=2:市、type=3:区、type=4:街道、type=5:社区)
                item.put("is_manage_center","0");
            }else{
                item.put("is_manage_center","1");
            }
            commonService.insert("insertSysOffice",item);

            // 添加机构下用户
            String user_id= UUIDUtil.randomUUID().toString();
            String loginName = commonService.getObject(nameSpace + "generateLoginName", item);
            item.put("user_id",user_id);
            item.put("loginName",loginName);
            commonService.insert(nameSpace+"insertUser",item);

            // 分配用户角色
            List<String> roleList=new ArrayList<>();
            if(item.get("type").equals("5")){// 社区
                roleList.add("85451817-2dfc-11ef-af17-f8f21ee9b878");
            }else if(item.get("type").equals("4")){// 街道
                roleList.add("85451799-2dfc-11ef-af17-f8f21ee9b878");
            }else if(item.get("type").equals("3")){// 区
                roleList.add("854516b6-2dfc-11ef-af17-f8f21ee9b878");
            }else if(item.get("type").equals("2")){// 市
                roleList.add("8545133b-2dfc-11ef-af17-f8f21ee9b878");
            }else if(item.get("type").equals("1")){// 省
                roleList.add("227b160d998e49a1a8d3bdb9ac4e4f11");
            }
            for (String role_id : roleList) {
                item.put("role_id",role_id);
                commonService.insert(nameSpace+"insertUserRole",item);
            }

            System.out.println("===================="+i);
        }
    }

}
