package com.scpyun.platform.jilinsscgsdp.bean.vo;

import java.util.Date;

import javax.validation.constraints.NotEmpty;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;

public class JlGridUserVo {
    /**
     * 主键ID
     */
    @NotEmpty(message = "id不可为空",groups = {Update.class,Delete.class})
    private String id;

    /**
     * appid
     */
    private String appid;

    /**
     * 地市对接id
     */
    private String docking_id;

    /**
     * 是否常住，0：常住，1：流动
     */
    @NotEmpty(message = "是否常住不可为空",groups = {Insert.class,Update.class})
    private String user_type;

    /**
     * 是否户籍，0：是户籍，1：非户籍
     */
    @NotEmpty(message = "是否户籍不可为空",groups = {Insert.class,Update.class})
    private String huji_type;

    /**
     * 是否空挂户   0:是，1:否
     */
    @NotEmpty(message = "是否空挂户不可为空",groups = {Insert.class,Update.class})
    private String is_kgh;

    /**
     * 与户主关系 0:户主 1:配偶  2:子女 3:父母 4:岳父岳母或公婆 5:祖父母 6:媳婿 7:孙子女 8:兄弟姐妹 9:外孙子女 10:租户 11:其他
     */
    @NotEmpty(message = "与户主关系不可为空",groups = {Insert.class,Update.class})
    private String relation;

    /**
     * 是否居住，0：居住，1：非居住
     */
    @NotEmpty(message = "是否居住不可为空",groups = {Insert.class,Update.class})
    private String juzhu_type;

    /**
     * 居住情况  1:自住 2:租住 3:借住 4:其他
     */
    @NotEmpty(message = "居住情况不可为空",groups = {Insert.class,Update.class})
    private String living_condition;

    /**
     * 姓名
     */
    @NotEmpty(message = "姓名不可为空",groups = {Insert.class,Update.class})
    private String user_name;

    /**
     * 证件类别 1:身份证 2:护照 3:台湾居民来往大陆通行证 4:港澳居民来往内地通行证 5:外国人永久居留身份证 6:台湾居民居住证 7:港澳居民居住证
     */
    //@NotEmpty(message = "证件类别不可为空",groups = {Insert.class,Update.class})
    private String card_type;

    /**
     * 身份证
     */
    @NotEmpty(message = "证件号码不可为空",groups = {Insert.class,Update.class})
    private String cardno;

    /**
     * 身份证正面
     */
    private String card_front_url;

    /**
     * 身份证反面
     */
    private String card_back_url;

    /**
     * 联系电话
     */
    @NotEmpty(message = "联系电话不可为空",groups = {Insert.class,Update.class})
    private String tel;

    /**
     * 民族
     */
    @NotEmpty(message = "民族不可为空",groups = {Insert.class,Update.class})
    private String folk;

    /**
     * 性别 1男 2女
     */
    @NotEmpty(message = "性别不可为空",groups = {Insert.class,Update.class})
    private String sex;

    /**
     * 政治面貌
     */
    private String political_outlook;

    /**
     * 头像
     */
    private String avatar_url;

    /**
     * 市id
     */
    private String city_id;

    /**
     * 区id
     */
    private String area_id;

    /**
     * 街道id
     */
    private String street_id;

    /**
     * 社区id
     */
    private String community_id;

    /**
     * 社区编码
     */
    private String community_code;

    /**
     * 网格id
     */
    private String garden_id;

    /**
     * 楼id
     */
    private String building_id;

    /**
     * 单元id
     */
    private String unit_id;

    /**
     * 层id
     */
    private String floor_id;

    /**
     * 户id
     */
    private String doorplate_id;

    /**
     * 是否删除  1删除 0正常
     */
    private String del_flag;

    /**
     * 创建人
     */
    private String create_by;

    /**
     * 创建时间
     */
    private Date create_time;

    /**
     * 更新人
     */
    private String update_by;

    /**
     * 更新时间
     */
    private Date update_time;

    /**
     * 是否重点人员：0是，1否
     */
    private String is_zdry;

    /**
     * 户籍地址
     */
    @NotEmpty(message = "户籍地址不可为空",groups = {Insert.class,Update.class})
    private String hj_address;

    /**
     * 现住址
     */
    @NotEmpty(message = "现住址不可为空",groups = {Insert.class,Update.class})
    private String now_address;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 主键ID
     * @return id 主键ID
     */
    public String getId() {
        return id;
    }

    /**
     * 主键ID
     * @param id 主键ID
     */
    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    /**
     * appid
     * @return appid appid
     */
    public String getAppid() {
        return appid;
    }

    /**
     * appid
     * @param appid appid
     */
    public void setAppid(String appid) {
        this.appid = appid == null ? null : appid.trim();
    }

    /**
     * 地市对接id
     * @return docking_id 地市对接id
     */
    public String getDocking_id() {
        return docking_id;
    }

    /**
     * 地市对接id
     * @param docking_id 地市对接id
     */
    public void setDocking_id(String docking_id) {
        this.docking_id = docking_id == null ? null : docking_id.trim();
    }

    /**
     * 是否常住，0：常住，1：流动
     * @return user_type 是否常住，0：常住，1：流动
     */
    public String getUser_type() {
        return user_type;
    }

    /**
     * 是否常住，0：常住，1：流动
     * @param user_type 是否常住，0：常住，1：流动
     */
    public void setUser_type(String user_type) {
        this.user_type = user_type == null ? null : user_type.trim();
    }

    /**
     * 是否户籍，0：是户籍，1：非户籍
     * @return huji_type 是否户籍，0：是户籍，1：非户籍
     */
    public String getHuji_type() {
        return huji_type;
    }

    /**
     * 是否户籍，0：是户籍，1：非户籍
     * @param huji_type 是否户籍，0：是户籍，1：非户籍
     */
    public void setHuji_type(String huji_type) {
        this.huji_type = huji_type == null ? null : huji_type.trim();
    }

    /**
     * 是否空挂户   0:是，1:否
     * @return is_kgh 是否空挂户   0:是，1:否
     */
    public String getIs_kgh() {
        return is_kgh;
    }

    /**
     * 是否空挂户   0:是，1:否
     * @param is_kgh 是否空挂户   0:是，1:否
     */
    public void setIs_kgh(String is_kgh) {
        this.is_kgh = is_kgh == null ? null : is_kgh.trim();
    }

    /**
     * 与户主关系 0:户主 1:配偶  2:子女 3:父母 4:岳父岳母或公婆 5:祖父母 6:媳婿 7:孙子女 8:兄弟姐妹 9:外孙子女 10:租户 11:其他
     * @return relation 与户主关系 0:户主 1:配偶  2:子女 3:父母 4:岳父岳母或公婆 5:祖父母 6:媳婿 7:孙子女 8:兄弟姐妹 9:外孙子女 10:租户 11:其他
     */
    public String getRelation() {
        return relation;
    }

    /**
     * 与户主关系 0:户主 1:配偶  2:子女 3:父母 4:岳父岳母或公婆 5:祖父母 6:媳婿 7:孙子女 8:兄弟姐妹 9:外孙子女 10:租户 11:其他
     * @param relation 与户主关系 0:户主 1:配偶  2:子女 3:父母 4:岳父岳母或公婆 5:祖父母 6:媳婿 7:孙子女 8:兄弟姐妹 9:外孙子女 10:租户 11:其他
     */
    public void setRelation(String relation) {
        this.relation = relation == null ? null : relation.trim();
    }

    /**
     * 是否居住，0：居住，1：非居住
     * @return juzhu_type 是否居住，0：居住，1：非居住
     */
    public String getJuzhu_type() {
        return juzhu_type;
    }

    /**
     * 是否居住，0：居住，1：非居住
     * @param juzhu_type 是否居住，0：居住，1：非居住
     */
    public void setJuzhu_type(String juzhu_type) {
        this.juzhu_type = juzhu_type == null ? null : juzhu_type.trim();
    }

    /**
     * 居住情况  1:自住 2:租住 3:借住 4:其他
     * @return living_condition 居住情况  1:自住 2:租住 3:借住 4:其他
     */
    public String getLiving_condition() {
        return living_condition;
    }

    /**
     * 居住情况  1:自住 2:租住 3:借住 4:其他
     * @param living_condition 居住情况  1:自住 2:租住 3:借住 4:其他
     */
    public void setLiving_condition(String living_condition) {
        this.living_condition = living_condition == null ? null : living_condition.trim();
    }

    /**
     * 姓名
     * @return user_name 姓名
     */
    public String getUser_name() {
        return user_name;
    }

    /**
     * 姓名
     * @param user_name 姓名
     */
    public void setUser_name(String user_name) {
        this.user_name = user_name == null ? null : user_name.trim();
    }

    /**
     * 证件类别 1:身份证 2:护照 3:台湾居民来往大陆通行证 4:港澳居民来往内地通行证 5:外国人永久居留身份证 6:台湾居民居住证 7:港澳居民居住证
     * @return card_type 证件类别 1:身份证 2:护照 3:台湾居民来往大陆通行证 4:港澳居民来往内地通行证 5:外国人永久居留身份证 6:台湾居民居住证 7:港澳居民居住证
     */
    public String getCard_type() {
        return card_type;
    }

    /**
     * 证件类别 1:身份证 2:护照 3:台湾居民来往大陆通行证 4:港澳居民来往内地通行证 5:外国人永久居留身份证 6:台湾居民居住证 7:港澳居民居住证
     * @param card_type 证件类别 1:身份证 2:护照 3:台湾居民来往大陆通行证 4:港澳居民来往内地通行证 5:外国人永久居留身份证 6:台湾居民居住证 7:港澳居民居住证
     */
    public void setCard_type(String card_type) {
        this.card_type = card_type == null ? null : card_type.trim();
    }

    /**
     * 身份证
     * @return cardno 身份证
     */
    public String getCardno() {
        return cardno;
    }

    /**
     * 身份证
     * @param cardno 身份证
     */
    public void setCardno(String cardno) {
        this.cardno = cardno == null ? null : cardno.trim();
    }

    /**
     * 身份证正面
     * @return card_front_url 身份证正面
     */
    public String getCard_front_url() {
        return card_front_url;
    }

    /**
     * 身份证正面
     * @param card_front_url 身份证正面
     */
    public void setCard_front_url(String card_front_url) {
        this.card_front_url = card_front_url == null ? null : card_front_url.trim();
    }

    /**
     * 身份证反面
     * @return card_back_url 身份证反面
     */
    public String getCard_back_url() {
        return card_back_url;
    }

    /**
     * 身份证反面
     * @param card_back_url 身份证反面
     */
    public void setCard_back_url(String card_back_url) {
        this.card_back_url = card_back_url == null ? null : card_back_url.trim();
    }

    /**
     * 联系电话
     * @return tel 联系电话
     */
    public String getTel() {
        return tel;
    }

    /**
     * 联系电话
     * @param tel 联系电话
     */
    public void setTel(String tel) {
        this.tel = tel == null ? null : tel.trim();
    }

    /**
     * 民族
     * @return folk 民族
     */
    public String getFolk() {
        return folk;
    }

    /**
     * 民族
     * @param folk 民族
     */
    public void setFolk(String folk) {
        this.folk = folk == null ? null : folk.trim();
    }

    /**
     * 性别 1男 2女
     * @return sex 性别 1男 2女
     */
    public String getSex() {
        return sex;
    }

    /**
     * 性别 1男 2女
     * @param sex 性别 1男 2女
     */
    public void setSex(String sex) {
        this.sex = sex == null ? null : sex.trim();
    }

    /**
     * 政治面貌
     * @return political_outlook 政治面貌
     */
    public String getPolitical_outlook() {
        return political_outlook;
    }

    /**
     * 政治面貌
     * @param political_outlook 政治面貌
     */
    public void setPolitical_outlook(String political_outlook) {
        this.political_outlook = political_outlook == null ? null : political_outlook.trim();
    }

    /**
     * 头像
     * @return avatar_url 头像
     */
    public String getAvatar_url() {
        return avatar_url;
    }

    /**
     * 头像
     * @param avatar_url 头像
     */
    public void setAvatar_url(String avatar_url) {
        this.avatar_url = avatar_url == null ? null : avatar_url.trim();
    }

    /**
     * 市id
     * @return city_id 市id
     */
    public String getCity_id() {
        return city_id;
    }

    /**
     * 市id
     * @param city_id 市id
     */
    public void setCity_id(String city_id) {
        this.city_id = city_id == null ? null : city_id.trim();
    }

    /**
     * 区id
     * @return area_id 区id
     */
    public String getArea_id() {
        return area_id;
    }

    /**
     * 区id
     * @param area_id 区id
     */
    public void setArea_id(String area_id) {
        this.area_id = area_id == null ? null : area_id.trim();
    }

    /**
     * 街道id
     * @return street_id 街道id
     */
    public String getStreet_id() {
        return street_id;
    }

    /**
     * 街道id
     * @param street_id 街道id
     */
    public void setStreet_id(String street_id) {
        this.street_id = street_id == null ? null : street_id.trim();
    }

    /**
     * 社区id
     * @return community_id 社区id
     */
    public String getCommunity_id() {
        return community_id;
    }

    /**
     * 社区id
     * @param community_id 社区id
     */
    public void setCommunity_id(String community_id) {
        this.community_id = community_id == null ? null : community_id.trim();
    }

    /**
     * 社区编码
     * @return community_code 社区编码
     */
    public String getCommunity_code() {
        return community_code;
    }

    /**
     * 社区编码
     * @param community_code 社区编码
     */
    public void setCommunity_code(String community_code) {
        this.community_code = community_code == null ? null : community_code.trim();
    }

    /**
     * 网格id
     * @return garden_id 网格id
     */
    public String getGarden_id() {
        return garden_id;
    }

    /**
     * 网格id
     * @param garden_id 网格id
     */
    public void setGarden_id(String garden_id) {
        this.garden_id = garden_id == null ? null : garden_id.trim();
    }

    /**
     * 楼id
     * @return building_id 楼id
     */
    public String getBuilding_id() {
        return building_id;
    }

    /**
     * 楼id
     * @param building_id 楼id
     */
    public void setBuilding_id(String building_id) {
        this.building_id = building_id == null ? null : building_id.trim();
    }

    /**
     * 单元id
     * @return unit_id 单元id
     */
    public String getUnit_id() {
        return unit_id;
    }

    /**
     * 单元id
     * @param unit_id 单元id
     */
    public void setUnit_id(String unit_id) {
        this.unit_id = unit_id == null ? null : unit_id.trim();
    }

    /**
     * 层id
     * @return floor_id 层id
     */
    public String getFloor_id() {
        return floor_id;
    }

    /**
     * 层id
     * @param floor_id 层id
     */
    public void setFloor_id(String floor_id) {
        this.floor_id = floor_id == null ? null : floor_id.trim();
    }

    /**
     * 户id
     * @return doorplate_id 户id
     */
    public String getDoorplate_id() {
        return doorplate_id;
    }

    /**
     * 户id
     * @param doorplate_id 户id
     */
    public void setDoorplate_id(String doorplate_id) {
        this.doorplate_id = doorplate_id == null ? null : doorplate_id.trim();
    }

    /**
     * 是否删除  1删除 0正常
     * @return del_flag 是否删除  1删除 0正常
     */
    public String getDel_flag() {
        return del_flag;
    }

    /**
     * 是否删除  1删除 0正常
     * @param del_flag 是否删除  1删除 0正常
     */
    public void setDel_flag(String del_flag) {
        this.del_flag = del_flag == null ? null : del_flag.trim();
    }

    /**
     * 创建人
     * @return create_by 创建人
     */
    public String getCreate_by() {
        return create_by;
    }

    /**
     * 创建人
     * @param create_by 创建人
     */
    public void setCreate_by(String create_by) {
        this.create_by = create_by == null ? null : create_by.trim();
    }

    /**
     * 创建时间
     * @return create_time 创建时间
     */
    public Date getCreate_time() {
        return create_time;
    }

    /**
     * 创建时间
     * @param create_time 创建时间
     */
    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    /**
     * 更新人
     * @return update_by 更新人
     */
    public String getUpdate_by() {
        return update_by;
    }

    /**
     * 更新人
     * @param update_by 更新人
     */
    public void setUpdate_by(String update_by) {
        this.update_by = update_by == null ? null : update_by.trim();
    }

    /**
     * 更新时间
     * @return update_time 更新时间
     */
    public Date getUpdate_time() {
        return update_time;
    }

    /**
     * 更新时间
     * @param update_time 更新时间
     */
    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    /**
     * 是否重点人员：0是，1否
     * @return is_zdry 是否重点人员：0是，1否
     */
    public String getIs_zdry() {
        return is_zdry;
    }

    /**
     * 是否重点人员：0是，1否
     * @param is_zdry 是否重点人员：0是，1否
     */
    public void setIs_zdry(String is_zdry) {
        this.is_zdry = is_zdry == null ? null : is_zdry.trim();
    }

    /**
     * 户籍地址
     * @return hj_address 户籍地址
     */
    public String getHj_address() {
        return hj_address;
    }

    /**
     * 户籍地址
     * @param hj_address 户籍地址
     */
    public void setHj_address(String hj_address) {
        this.hj_address = hj_address == null ? null : hj_address.trim();
    }

    /**
     * 现住址
     * @return now_address 现住址
     */
    public String getNow_address() {
        return now_address;
    }

    /**
     * 现住址
     * @param now_address 现住址
     */
    public void setNow_address(String now_address) {
        this.now_address = now_address == null ? null : now_address.trim();
    }

    /**
     * 备注
     * @return remarks 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     * @param remarks 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }
}