package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Author liu
 * @Date 2025/9/25 16:50
 * @PackageName:com.scpyun.platform.jilinsscgsdp.service.impl
 * @ClassName: KeyPersonRating
 * @Description: TODO
 * @Version 1.0
 */
@Api("评分等级划分设置")
@Service("keyPersonRatingLevel")
public class KeyPersonRatingLevelServiceImpl {
    @Autowired
    CommonService commonService;

    private final String SUCCESS = "success";

    private String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyPersonRatingLevel.";

    @ApiOperation(value = "查询评分等级划分列表", desc = "按类别返回所有评分等级分段")
    public List<Map<String, Object>> selectRatingLevelList(Map<String, Object> map) {
        if (map == null) {
            throw new CustomException("参数不能为空");
        }
        Object type = map.get("rating_dict_type");
        if (type == null || StringUtils.isBlank(String.valueOf(type))) {
            throw new CustomException("缺少重点人员类别");
        }
        return commonService.findList(namespace + "selectRatingLevelList", map);
    }

    @ApiOperation(value = "保存评分等级划分", desc = "整类覆盖保存，先删后插，左闭右开且连续")
    @Transactional(rollbackFor = Exception.class)
    public String saveRatingLevel(Map<String, Object> map) {
        if (map == null) {
            throw new CustomException("参数不能为空");
        }
        Object type = map.get("rating_dict_type");
        if (type == null || StringUtils.isBlank(String.valueOf(type))) {
            throw new CustomException("缺少重点人员类别");
        }
        Object itemsObj = map.get("items");
        if (!(itemsObj instanceof List)) {
            throw new CustomException("items 参数必须为列表");
        }
        @SuppressWarnings("unchecked")
        List<Map<String, Object>> items = (List<Map<String, Object>>) itemsObj;
        if (items.isEmpty()) {
            throw new CustomException("评分等级不能为空");
        }
        Integer prevEnd = null;
        for (int i = 0; i < items.size(); i++) {
            Map<String, Object> it = items.get(i);
            String startStr = String.valueOf(it.get("rating_start_score"));
            String endStr = String.valueOf(it.get("rating_end_score"));
            if (!startStr.matches("\\d+") || !endStr.matches("\\d+")) {
                throw new CustomException("起止分数必须为大于等于0的整数");
            }
            int start = Integer.parseInt(startStr);
            int end = Integer.parseInt(endStr);
            if (start < 0 || end < 0) {
                throw new CustomException("分数必须为大于等于0的整数");
            }
            if (end <= start) {
                throw new CustomException("结束分数必须大于起始分数");
            }
            if (i == 0) {
                if (start != 0) {
                    throw new CustomException("第一档起始分数必须为0");
                }
            } else {
                if (prevEnd == null || start != prevEnd) {
                    throw new CustomException("评分等级必须首尾相接，不能有跳跃或交叉");
                }
            }
            prevEnd = end;
        }
        commonService.delete(namespace + "deleteByType", map);
        for (Map<String, Object> it : items) {
            it.put("rating_dict_type", String.valueOf(type));
            it.put("_user", map.get("_user"));
            int n = commonService.insert(namespace + "insert", it);
            if (n != 1) {
                throw new CustomException("保存失败");
            }
        }
        return SUCCESS;
    }
}
