package com.scpyun.platform.jilinsscgsdp.bean.vo.task;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * @Author liu
 * @Date 2024/10/11 14:16
 * @PackageName:com.scpyun.platform.jilinexchange.bean.vo
 * @ClassName: ReqBuildingVo
 * @Description: TODO
 * @Version 1.0
 */
public class ReqBuildingVo extends ReqBaseVo{
    /**
     * 主键
     */
    @NotEmpty(message = "id不可为空",groups = {Insert.class,Update.class,Delete.class})
    @Length(min=1, max=200,message = "id数据长度范围1到200",groups = {Insert.class,Update.class,Delete.class})
    private String id;

    /**
     * 楼宇名称
     */
    @NotEmpty(message = "楼宇名称不可为空")
    @Length(min=1, max=40,message = "楼宇名称数据长度范围1到40",groups = {Insert.class,Update.class})
    private String name;

    /**
     * 详细地址蓝牌号
     */
    @NotEmpty(message = "详细地址蓝牌号不可为空")
    @Length(min=1, max=255,message = "详细地址蓝牌号数据长度范围1到200",groups = {Insert.class,Update.class})
    private String brand;

    /**
     * 坐标
     */
    @NotEmpty(message = "坐标不可为空")
    @Length(min=1, max=300,message = "坐标数据长度范围1到300",groups = {Insert.class,Update.class})
    private String cscMapjsonHt;

    /**
     * 市编码
     */
    @NotEmpty(message = "市编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "市编码格式异常",groups = {Insert.class,Update.class})
    private String cityCode;

    /**
     * 区编码
     */
    @NotEmpty(message = "区编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "区编码格式异常",groups = {Insert.class,Update.class})
    private String areaCode;

    /**
     * 街道编码
     */
    @NotEmpty(message = "街道不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "街道编码格式异常",groups = {Insert.class,Update.class})
    private String streetCode;

    /**
     * 社区编码
     */
    @NotEmpty(message = "社区不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "社区编码格式异常",groups = {Insert.class,Update.class})
    private String communityCode;

    /**
     * 网格ID
     */
    @NotEmpty(message = "网格ID不可为空")
//    @Length(min=1, max=40,message = "网格ID数据长度范围1到40",groups = {Insert.class,Update.class})
    private String gardenId;

    /**
     * 楼ID
     */
    @NotEmpty(message = "小区ID不可为空")
//    @Length(min=1, max=40,message = "网格ID数据长度范围1到40",groups = {Insert.class,Update.class})
    private String residentialId;

    /**
     * appid
     */
    @NotEmpty(message = "appid不可为空")
    @Length(min=1, max=36,message = "appid数据长度范围1到36",groups = {Insert.class,Update.class,Delete.class})
    private String appid;

    /**
     * 社区账号
     */
    private String companyCode;

    /**
     * 地市对接id
     */
    private String dockingId;

    /**
     * 添加状态
     */
    private String type;

    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;
    
    private String mapType;
    
    private String grade;
    private Integer intId;

    public Integer getIntId() {
        return intId;
    }

    public void setIntId(Integer intId) {
        this.intId = intId;
    }
    public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	public String getMapType() {
		return mapType;
	}

	public void setMapType(String mapType) {
		this.mapType = mapType;
	}

	public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getResidentialId() {
        return residentialId;
    }

    public void setResidentialId(String residentialId) {
        this.residentialId = residentialId;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getCscMapjsonHt() {
        return cscMapjsonHt;
    }

    public void setCscMapjsonHt(String cscMapjsonHt) {
        this.cscMapjsonHt = cscMapjsonHt;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getCommunityCode() {
        return communityCode;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }

    public String getGardenId() {
        return gardenId;
    }

    public void setGardenId(String gardenId) {
        this.gardenId = gardenId;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }
    
    public static void main(String[] args) {
		System.out.println("9329d8d3-b139-11ef-ba9a-0242c0a81f03".length());
	}
}
