package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.db.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api("统计服务")
@Service("keyDmStats")
public class KeyDmStatsServiceImpl {
    @Autowired
    private CommonService commonService;

    private final String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyDmStats.";

    @ApiOperation(value = "使用统计", desc = "统计各部门领用量")
    public List<Map<String, Object>> selectUsageStats(Map<String, Object> map) {
        if (map == null) map = new HashMap<>();
        return commonService.findList(namespace + "selectUsageStats", map);
    }

    @ApiOperation(value = "使用明细", desc = "查询使用明细")
    public List<Map<String, Object>> selectUsageDetails(Map<String, Object> map) {
        if (map == null) map = new HashMap<>();
        return commonService.findList(namespace + "selectUsageDetails", map);
    }

    @ApiOperation(value = "工作量统计", desc = "统计人员工作量")
    public List<Map<String, Object>> selectWorkloadStats(Map<String, Object> map) {
        if (map == null) map = new HashMap<>();
        return commonService.findList(namespace + "selectWorkloadStats", map);
    }

    @ApiOperation(value = "工作量明细", desc = "工作量明细")
    public List<Map<String, Object>> selectWorkloadDetails(Map<String, Object> map) {
        if (map == null) map = new HashMap<>();
        return commonService.findList(namespace + "selectWorkloadDetails", map);
    }
}


