package com.scpyun.platform.jilinsscgsdp.task.impl;

import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Component
public class FocusRegionNewTask {

    @Autowired
    CommonService commonService;
    RedissonClient redissonClient = SpringContextHolder.getBean(RedissonClient.class);
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.FocusAreaRegionTaskDao.";


    @Scheduled(cron = "0 */10 * * * ?")
    public void insertFocusRegion() {
        RLock rLock = redissonClient.getLock("jilinexchange:insertFocusRegion");
        try {
            if (rLock.tryLock(0, TimeUnit.SECONDS)) {
                List<Map<String, Object>> areaList = commonService.findList(nameSpace + "getAreaList", null);

                LocalDate today = LocalDate.now();
                String current_month = today.format(DateTimeFormatter.ofPattern("MM"));

                String current_year = today.format(DateTimeFormatter.ofPattern("yyyy"));
                Map<String, Object> delParam = new HashMap<>();
                delParam.put("year", current_year);
                delParam.put("month", current_month);
                delParam.put("data_type", "0");
                commonService.delete(nameSpace +"deleteFocusRegionNew",delParam);
                for (Map<String, Object> item : areaList) {
                    // 获取上一月各纠纷大类的 矛盾数量
                    int lastMonthCount = commonService.getObject(nameSpace + "getLastMonthCount", item);
                    // 获取当前月各纠纷大类的 矛盾数量
                    int currentMonthCount = commonService.getObject(nameSpace + "getCurrentMonthCount", item);
                    if (currentMonthCount >= 15) {
                        // 计算环比增长率
                        double res;
                        if (lastMonthCount == 0) {
                            res = currentMonthCount == 0 ? 0 : 100;
                        } else {
                            res = ((double) (currentMonthCount - lastMonthCount) / lastMonthCount) * 100;
                        }
                        int resInt = (int) Math.round(res);
                        if (resInt > 30) {
                            Map<String, Object> param = new HashMap<>();
                            param.put("year", current_year);
                            param.put("month", current_month);
                            param.put("area_code", item.get("value"));
                            param.put("growth_rate", resInt);
                            param.put("data_type", "0");
                            param.put("event_count", currentMonthCount);
                            commonService.insert(nameSpace + "insertFocusRegionNew", param);
                        }
                    }
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }

    @Scheduled(cron = "0 */10 * * * ?")
    public void insertFocusAreaWithYear() {
        RLock rLock = redissonClient.getLock("jilinexchange:insertFocusAreaWithYear");
        try {
            if (rLock.tryLock(0, TimeUnit.SECONDS)) {
                List<Map<String, Object>> areaList = commonService.findList(nameSpace + "getAreaList", null);

                LocalDate today = LocalDate.now();
                String current_month = today.format(DateTimeFormatter.ofPattern("MM"));

                String current_year = today.format(DateTimeFormatter.ofPattern("yyyy"));

                Map<String, Object> delParam = new HashMap<>();
                delParam.put("year", current_year);
                delParam.put("month", current_month);
                delParam.put("data_type", "1");
                commonService.delete(nameSpace +"deleteFocusRegionNew",delParam);
                for (Map<String, Object> item : areaList) {
                    // 获取上一年各纠纷大类的 矛盾数量
                    int lastYearCount = commonService.getObject(nameSpace + "getLastYearCount", item);
                    // 获取当前年各纠纷大类的 矛盾数量
                    int currentYearCount = commonService.getObject(nameSpace + "getCurrentYearCount", item);
                    if (currentYearCount >= 15) {
                        // 计算环比增长率
                        double res;
                        if (lastYearCount == 0) {
                            res = currentYearCount == 0 ? 0 : 100;
                        } else {
                            res = ((double) (currentYearCount - lastYearCount) / lastYearCount) * 100;
                        }
                        int resInt = (int) Math.round(res);
                        if (resInt > 50) {
                            Map<String, Object> param = new HashMap<>();
                            param.put("year", current_year);
                            param.put("month", current_month);
                            param.put("area_code", item.get("value"));
                            param.put("growth_rate", resInt);
                            param.put("data_type", "1");
                            param.put("event_count", currentYearCount);
                            commonService.insert(nameSpace + "insertFocusRegionNew", param);
                        }
                    }
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }
}
