package com.scpyun.platform.jilinsscgsdp.validator;

import cn.hutool.core.util.IdcardUtil;
import com.scpyun.platform.jilinsscgsdp.annotation.IdCard;
import org.springframework.util.ObjectUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 身份证号码，格式校验器
 */
public class IdCardValidator implements ConstraintValidator<IdCard, String> {

    @Override
    public void initialize(IdCard constraintAnnotation) {
        ConstraintValidator.super.initialize(constraintAnnotation);
    }


    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (ObjectUtils.isEmpty(value)) {
            return true;
        }
        return IdcardUtil.isValidCard(value);
    }

}

