package com.scpyun.platform.jilinsscgsdp.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.DataSourceSwitcher;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;

@Api("最新版本统计---首页card")
@Service("gridCardInfoForGridService")
public class GridCardInfoForGridServiceImpl {

	@Autowired
	CommonService commonService;
	private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.gridCardInfo.";

	@ApiOperation(value = "查询office层级机构数量",desc = "查询office层级机构数量")
	public Map<String, Object> getOfficeStatistics(Map<String, Object> map){
		Map<String, Object> retMap = new HashMap<String, Object>();
		retMap.put("info", this.getLevelInfo(map));
		String grade = StringUtils.toString(map.get("grade"));
		//市级
		if("3".equals(grade)) {
			Map<String, Object> aMap = commonService.getObject(nameSpace+"getOfficeAreaNum", map);
			Map<String, Object> bMap = commonService.getObject(nameSpace+"getOfficeStreetNum", map);
			Map<String, Object> cMap = commonService.getObject(nameSpace+"getOfficeCommunityNum", map);
			//Map<String, Object> dMap = commonService.getObject(nameSpace+"getOfficeCunNum", map);
			//Map<String,Object> eMap = commonService.getObject(nameSpace+"getOfficeXzNum", map);
			retMap.put("areaNum", aMap.get("num"));
			retMap.put("streetNum", bMap.get("num"));
			retMap.put("communityNum", cMap.get("num"));
			//retMap.put("cunNum", dMap.get("num"));
			//retMap.put("xzNum", eMap.get("num"));
			DataSourceSwitcher.setSharding("grid");
			DataSourceSwitcher.setSlave();
			Map<String, Object> communityPaintMap = commonService.getObject(nameSpace+"getPaintOfficeCommunityNum", map);
			retMap.put("paintCommunityNum", communityPaintMap.get("num"));
			//Map<String, Object> cunPaintMap = commonService.getObject(nameSpace+"getPaintOfficeCunNum", map);
			//retMap.put("paintCunNum", cunPaintMap.get("num"));
		}else
		//区级
		if("4".equals(grade)) {
			Map<String, Object> bMap = commonService.getObject(nameSpace+"getOfficeStreetNum", map);
			Map<String, Object> cMap = commonService.getObject(nameSpace+"getOfficeCommunityNum", map);
			//Map<String, Object> dMap = commonService.getObject(nameSpace+"getOfficeCunNum", map);
			//Map<String,Object> eMap = commonService.getObject(nameSpace+"getOfficeXzNum", map);
			retMap.put("streetNum", bMap.get("num"));
			retMap.put("communityNum", cMap.get("num"));
			//retMap.put("cunNum", dMap.get("num"));
			//retMap.put("xzNum", eMap.get("num"));
			DataSourceSwitcher.setSharding("grid");
			DataSourceSwitcher.setSlave();
			Map<String, Object> communityPaintMap = commonService.getObject(nameSpace+"getPaintOfficeCommunityNum", map);
			retMap.put("paintCommunityNum", communityPaintMap.get("num"));
			//Map<String, Object> cunPaintMap = commonService.getObject(nameSpace+"getPaintOfficeCunNum", map);
			//retMap.put("paintCunNum", cunPaintMap.get("num"));
		}else
		//乡镇街道
		if("5".equals(grade)) {
			Map<String, Object> cMap = commonService.getObject(nameSpace+"getOfficeCommunityNum", map);
			//Map<String, Object> dMap = commonService.getObject(nameSpace+"getOfficeCunNum", map);
			retMap.put("communityNum", cMap.get("num"));
			//retMap.put("cunNum", dMap.get("num"));
			DataSourceSwitcher.setSharding("grid");
			DataSourceSwitcher.setSlave();
			Map<String, Object> communityPaintMap = commonService.getObject(nameSpace+"getPaintOfficeCommunityNum", map);
			retMap.put("paintCommunityNum", communityPaintMap.get("num"));
			//Map<String, Object> cunPaintMap = commonService.getObject(nameSpace+"getPaintOfficeCunNum", map);
			//retMap.put("paintCunNum", cunPaintMap.get("num"));
		}
		return retMap;
	}
	@ApiOperation(value = "查询网格数量（社区，村）",desc = "查询网格数量（社区，村）")
	public Map<String,Object> getGardenNum(Map<String, Object> map){
		map.put("level", "40");
		Map<String, Object>	communityGardenNum = commonService.getObject(nameSpace+"getGardenNum", map);
		map.put("level", "45");
		Map<String, Object>	cunGardenNum = commonService.getObject(nameSpace+"getGardenNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("communityGardenNum", communityGardenNum.get("num"));
		retMap.put("cunGardenNum", cunGardenNum.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询楼数量",desc = "查询楼数量")
	public Map<String,Object> getBuildingNum(Map<String, Object> map){
		Map<String, Object>	buildingNum = commonService.getObject(nameSpace+"getBuildingNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("buildingNum", buildingNum.get("num"));
		return retMap;
	}

	@ApiOperation(value = "查询房屋数（户数）",desc = "查询房屋数（户数）")
	//@selectRedis(key = "shenyang.qstb.grid.new.doorplateNum.community",notSaveToRedisgrade = 5)
	public Map<String, Object> getDoorplateNumCommunity(Map<String, Object> map){
		map.put("level", "40");
		Map<String, Object> doorplateNum= commonService.getObject(nameSpace+"getDoorplateNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", doorplateNum.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询房屋数（户数）",desc = "查询房屋数（户数）")
	//@selectRedis(key = "shenyang.qstb.grid.new.doorplateNum.cun",notSaveToRedisgrade = 5)
	public Map<String, Object> getDoorplateNumCun(Map<String, Object> map){
		map.put("level", "45");
		Map<String, Object> doorplateNum= commonService.getObject(nameSpace+"getDoorplateNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", doorplateNum.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询入户人数（社区）",desc = "查询入户人数（社区）")
	//@selectRedis(key = "shenyang.qstb.grid.new.userNum.community",notSaveToRedisgrade = 5)
	public Map<String, Object> getUserNumCommunity(Map<String, Object> map){
    	DataSourceSwitcher.setMaster();
    	//DataSourceSwitcher.setShardingSphere("ShardingDataSource");
    	
		map.put("level", "40");
		Map<String, Object> doorplateNum= commonService.getObject(nameSpace+"getUserNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", doorplateNum.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询入户人数（村）",desc = "查询入户人数（村）")
	//@selectRedis(key = "shenyang.qstb.grid.new.userNum.cun",notSaveToRedisgrade = 5)
	public Map<String, Object> getUserNumCun(Map<String, Object> map){
		map.put("level", "45");
		Map<String, Object> doorplateNum= commonService.getObject(nameSpace+"getUserNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", doorplateNum.get("num"));
		return retMap;
	}
	public Map<String, Object> getLevelInfo(Map<String, Object> map){
		if(StringUtils.isEmpty(map.get("id"))) {
			throw new CustomException("缺少参数！");
		}
		if(StringUtils.isEmpty(map.get("grade"))) {
			throw new CustomException("缺少参数！");
		}
		String grade = StringUtils.toString(map.get("grade"));
		if("3".equals(grade) || "4".equals(grade) || "5".equals(grade) || "6".equals(grade)) {
			DataSourceSwitcher.setSharding("sc");
			DataSourceSwitcher.setSlave();
			map.put("tableName", "sys_office");
		}else if("7".equals(grade)){
			map.put("tableName", "jl_grid_garden");
		}else if("8".equals(grade)){
			map.put("tableName", "jl_grid_building");
		}
		else {
			throw new CustomException("层级错误！");
		}
		Map<String, Object> retMap= commonService.getObject(nameSpace+"getLevelInfo", map);
		if("7".equals(grade) || "8".equals(grade)) {
			DataSourceSwitcher.setSharding("sc");
			DataSourceSwitcher.setSlave();
			Map<String, Object> aMap= commonService.getObject(nameSpace+"getCompanyInfoByid", retMap);
			retMap.put("level", aMap.get("level"));
			retMap.put("name", aMap.get("name")+"-"+retMap.get("name"));
		}
		if(retMap == null) {
			throw new CustomException("查询失败！");
		}
		return retMap;
	}
	@ApiOperation(value = "",desc = "")
	public Map<String, Object> getCompanyInfo(Map<String, Object> map){
		if(StringUtils.isEmpty(map.get("company_code"))) {
			throw new CustomException("缺少参数！");
		}
		DataSourceSwitcher.setSharding("sc");
		DataSourceSwitcher.setSlave();
		return commonService.getObject(nameSpace+"getCompanyInfoByCode", map);
	}

	@ApiOperation(value = "常住人口数量查询",desc = "常住人口数量查询")
	//@selectRedis(key = "shenyang.qstb.grid.new.dp.usertype",notSaveToRedisgrade = 4)
	public Map<String, Object> getUserTypeNum(Map<String, Object> map){
		Map<String, Object> numMap = commonService.getObject(nameSpace+"getUserTypeNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", numMap.get("num"));
		return retMap;
	}
	@ApiOperation(value = "户籍人口数量查询",desc = "户籍人口数量查询")
	//@selectRedis(key = "shenyang.qstb.grid.new.dp.hujitype",notSaveToRedisgrade = 4)
	public Map<String, Object> getHuJiTypeNum(Map<String, Object> map){
		Map<String, Object> numMap = commonService.getObject(nameSpace+"getHuJiTypeNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", numMap.get("num"));
		return retMap;
	}
	@ApiOperation(value = "流动人口数量查询",desc = "流动人口数量查询")
	//@selectRedis(key = "shenyang.qstb.grid.new.dp.liudong",notSaveToRedisgrade = 4)
	public Map<String, Object> getLiuDongTypeNum(Map<String, Object> map){
		Map<String, Object> numMap = commonService.getObject(nameSpace+"getLiuDongTypeNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", numMap.get("num"));
		return retMap;
	}
	@ApiOperation(value = "户籍居住人口数量查询",desc = "户籍居住人口数量查询")
	//@selectRedis(key = "shenyang.qstb.grid.new.dp.hujijuzhu",notSaveToRedisgrade = 4)
	public Map<String, Object> getHuJiJuZhuTypeNum(Map<String, Object> map){
		Map<String, Object> numMap = commonService.getObject(nameSpace+"getHuJiJuZhuTypeNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", numMap.get("num"));
		return retMap;
	}
	@ApiOperation(value = "常住居住人口数量查询",desc = "常住居住人口数量查询")
	//@selectRedis(key = "shenyang.qstb.grid.new.dp.changzhujuzhu",notSaveToRedisgrade = 4)
	public Map<String, Object> getChangZhuJuZhuTypeNum(Map<String, Object> map){
		Map<String, Object> numMap = commonService.getObject(nameSpace+"getChangZhuJuZhuTypeNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", numMap.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询人数（不区分村，社区）",desc = "查询人数（不区分村，社区）")
	//@selectRedis(key = "shenyang.qstb.grid.ruHuPeopleNum",notSaveToRedisgrade = 4)
	public Map<String, Object> getPeopleNum(Map<String, Object> map){
		Map<String, Object> numMap = commonService.getObject(nameSpace + "getUserNumAll", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", numMap.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询疫苗人数（接种）",desc = "查询疫苗人数（接种）")
	//@selectRedis(key = "shenyang.qstb.grid.new.user.label.ym.yes",notSaveToRedisgrade = 4)
	public Map<String, Object> getYmPeopleYesNum(Map<String, Object> map){
		Map<String, Object> numMap = commonService.getObject(nameSpace + "getUserNumForYmYes", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", numMap.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询疫苗人数（未接种）",desc = "查询疫苗人数（未接种）")
	//@selectRedis(key = "shenyang.qstb.grid.new.user.label.ym.no",notSaveToRedisgrade = 4)
	public Map<String, Object> getYmPeopleNoNum(Map<String, Object> map){
		Map<String, Object> numMap = commonService.getObject(nameSpace + "getUserNumForYmNo", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", numMap.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询入户人数(排重)",desc = "查询入户人数(排重)")
	//@selectRedis(key = "shenyang.qstb.grid.new.userNum.distinct",notSaveToRedisgrade = 4)
	public Map<String, Object> getDistInctUserNum(Map<String, Object> map){
    	DataSourceSwitcher.setMaster();
    	//DataSourceSwitcher.setShardingSphere("ShardingDataSource");
		Map<String, Object> doorplateNum= commonService.getObject(nameSpace+"getDistInctUserNum", map);
		Map<String,Object> retMap = new HashMap<String, Object>();
		retMap.put("num", doorplateNum.get("num"));
		return retMap;
	}

//	@ApiOperation(value = "查询小区数量",desc = "查询小区数量")
//	public Map<String,Object> getResidentialNum(Map<String, Object> map){
//		map.put("level", "40");
//		Map<String, Object>	communityGardenNum = commonService.getObject(nameSpace+"getResidentialNum", map);
//		map.put("level", "45");
//		Map<String, Object>	cunGardenNum = commonService.getObject(nameSpace+"getResidentialNum", map);
//		Map<String,Object> retMap = new HashMap<String, Object>();
//		retMap.put("communityResidentialNum", communityGardenNum.get("num"));
//		retMap.put("cunResidentialNum", cunGardenNum.get("num"));
//		return retMap;
//	}

	@ApiOperation(value = "查询实际居住户数",desc = "查询实际居住户数")
	//@selectRedis(key = "shenyang.qstb.grid.new.doorplate.actual.residenceNum.community",notSaveToRedisgrade = 3)
	public Map<String,Object> getActualResidenceNumCommunity(Map<String,Object> map){
		map.put("level", "40");
		Map<String,Object> actualResidenceNum = commonService.getObject(nameSpace + "getActualResidenceNum",map);
		Map<String,Object> retMap = new HashMap<>();
		retMap.put("num",actualResidenceNum.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询实际居住户数",desc = "查询实际居住户数")
	//@selectRedis(key = "shenyang.qstb.grid.new.doorplate.actual.residenceNum.cun",notSaveToRedisgrade = 3)
	public Map<String,Object> getActualResidenceNumCun(Map<String,Object> map){
		map.put("level", "45");
		Map<String,Object> actualResidenceNum = commonService.getObject(nameSpace + "getActualResidenceNum",map);
		Map<String,Object> retMap = new HashMap<>();
		retMap.put("num",actualResidenceNum.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询空户数",desc = "查询空户数")
	//@selectRedis(key = "shenyang.qstb.grid.new.doorplate.kh.community",notSaveToRedisgrade = 4)
	public Map<String,Object> getKHNumCommunity(Map<String,Object> map){
		map.put("level", "40");
		Map<String,Object> actualResidenceNum = commonService.getObject(nameSpace + "getKHNum",map);
		Map<String,Object> retMap = new HashMap<>();
		retMap.put("num",actualResidenceNum.get("num"));
		return retMap;
	}
	@ApiOperation(value = "查询空户数",desc = "查询空户数")
	//@selectRedis(key = "shenyang.qstb.grid.new.doorplate.kh.cun",notSaveToRedisgrade = 4)
	public Map<String,Object> getKHNumCun(Map<String,Object> map){
		map.put("level", "45");
		Map<String,Object> actualResidenceNum = commonService.getObject(nameSpace + "getKHNum",map);
		Map<String,Object> retMap = new HashMap<>();
		retMap.put("num",actualResidenceNum.get("num"));
		return retMap;
	}
	
	@ApiOperation(value = "查询实际居住户数",desc = "查询实际居住户数")
	public Map<String,Object> getOthersStaticNums(Map<String,Object> map){
		Map<String,Object> retMap = new HashMap<>();
		
        CompletableFuture<Long> futureMerchantNum = CompletableFuture.supplyAsync(() -> {
        	DataSourceSwitcher.setSlave();
        	DataSourceSwitcher.setSharding("all");
        	Long count=commonService.getObject(nameSpace + "getMerchantNum",map);
            return count;
        });
        
        CompletableFuture<Long> futureSocietyNum = CompletableFuture.supplyAsync(() -> {
        	DataSourceSwitcher.setSlave();
        	DataSourceSwitcher.setSharding("all");
        	Long count=commonService.getObject(nameSpace + "getSocietyNum",map);
            return count;
        });
        
        CompletableFuture<Long> futureSubstanceNum = CompletableFuture.supplyAsync(() -> {
        	DataSourceSwitcher.setSlave();
        	DataSourceSwitcher.setSharding("all");
        	Long count=commonService.getObject(nameSpace + "getSubstanceNum",map);
            return count;
        });
        
        CompletableFuture<Long> futureOrgNum = CompletableFuture.supplyAsync(() -> {
        	DataSourceSwitcher.setSlave();
        	DataSourceSwitcher.setSharding("all");
        	Long count=commonService.getObject(nameSpace + "getOrgNum",map);
            return count;
        });

        try {
    		retMap.put("merchantNum",futureMerchantNum.get());
    		retMap.put("societyNum",futureSocietyNum.get());
    		retMap.put("substanceNum",futureSubstanceNum.get());
    		retMap.put("orgNum",futureOrgNum.get());
        } catch (InterruptedException | ExecutionException e) {
            // 处理异常，例如记录日志或重新抛出
            e.printStackTrace();
        }
		return retMap;
	}
}