package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.UUIDUtil;
import com.scpyun.base.db.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api("人员分类管理")
@Service("keyDmUserCategory")
public class KeyDmUserCategoryServiceImpl {
    @Autowired
    private CommonService commonService;

    private static final String SUCCESS = "success";
    private final String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyDmUserCategory.";

    @ApiOperation(value = "查询人员分类", desc = "查询人员分类")
    public List<Map<String, Object>> findList(Map<String,Object> map) {
        if (map == null) {
            map = new HashMap<>();
        }

        return commonService.findList(namespace + "findList", map);
    }

    @ApiOperation(value = "查询人员分类列表", desc = "分页查询人员分类")
    public Page<Map<String, Object>> selectList(Page<Map<String,Object>> map) {
        if (map == null) {
            map = new Page<>();
        }

        return commonService.findPage(namespace + "selectList", map);
    }

    @ApiOperation(value = "保存人员分类", desc = "新增或修改人员分类")
    public String save(Map<String, Object> map) {
        if (map == null) {
            throw new CustomException("参数不能为空");
        }
        Object id = map.get("id");
        if (id == null || String.valueOf(id).trim().isEmpty()) {
            // 新增
            map.put("id", UUIDUtil.getUUID());
            if (commonService.insert(namespace + "insert", map) != 1) {
                throw new CustomException("保存失败");
            }
        } else {
            // 修改
            int affected = commonService.update(namespace + "update", map);
            if (affected < 0) {
                throw new CustomException("保存失败");
            }
        }
        return SUCCESS;
    }

    @ApiOperation(value = "删除人员分类", desc = "逻辑删除人员分类")
    public String delete(Map<String, Object> map) {
        if (map == null || map.get("id") == null) {
            throw new CustomException("参数不能为空");
        }
        int affected = commonService.update(namespace + "delete", map);
        if (affected < 0) {
            throw new CustomException("删除失败");
        }
        return SUCCESS;
    }

    @ApiOperation(value = "获取人员权限配置列表", desc = "从字典获取权限并关联用户")
    public List<Map<String, Object>> selectPermissionConfigList() {
        return commonService.findList(namespace + "selectPermissionConfigList", null);
    }

    @ApiOperation(value = "保存权限用户配置", desc = "保存权限对应的用户配置")
    public String savePermissionUsers(Map<String, Object> map) {
        if (map == null || map.get("permission_code") == null) {
            throw new CustomException("参数缺失");
        }

        String permissionCode = map.get("permission_code").toString();
        @SuppressWarnings("unchecked")
        List<String> userIds = (List<String>) map.get("user_ids");

        // 先删除原有配置
        Map<String, Object> deleteParam = new HashMap<>();
        deleteParam.put("permission_code", permissionCode);
        commonService.delete(namespace + "deletePermissionUsers", deleteParam);

        // 再插入新配置
        if (userIds != null && !userIds.isEmpty()) {
            for (String userId : userIds) {
                Map<String, Object> insertParam = new HashMap<>();
                insertParam.put("permission_code", permissionCode);
                insertParam.put("user_id", userId);
                commonService.insert(namespace + "insertPermissionUser", insertParam);
            }
        }

        return SUCCESS;
    }

}

