package com.scpyun.platform.jilinsscgsdp.bean.vo.task;


import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

public class ReqEventVo extends ReqBaseVo{
    /**
     * 详细地址
     */
    private String address;
    /**
     * 所属区编码
     */
    @NotEmpty(message = "所属区编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "所属区编码格式异常", groups = {Insert.class, Update.class})
    private String areaCode;

    /**
     * 楼栋id
     */
    private String buildingId;
    /**
     * 所属市编码
     */
    @NotEmpty(message = "所属市编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "所属市编码格式异常", groups = {Insert.class, Update.class})
    private String cityCode;
    /**
     * 社区编码
     */
    @NotEmpty(message = "社区编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "社区编码格式异常", groups = {Insert.class, Update.class})
    private String communityCode;
    /**
     * 办结时间
     */
    private String completeTime;
    /**
     * 纠纷描述
     */
    @NotEmpty(message = "纠纷描述不可为空", groups = {Insert.class, Update.class})
    private String disputeDescription;
    /**
     * 户id
     */
    private String doorplateId;
    /**
     * 预警时间
     */
    private String earlyWarningTime;
    /**
     * 纠纷大类(字典表type=event_category)
     */
    @NotEmpty(message = "纠纷大类不可为空", groups = {Insert.class, Update.class})
    @Length(max = 36, message = "纠纷大类字符长度不可超过36", groups = {Insert.class, Update.class})
    private String eventCategoryId;
    /**
     * 事件编号
     */
    @NotEmpty(message = "事件编号不可为空", groups = {Insert.class, Update.class})
    @Length(max = 25, message = "事件编号字符长度不可超过25", groups = {Insert.class, Update.class})
    private String eventCode;
    /**
     * 事件类别 1:直报事件 2:矛盾纠纷 3:舆情观察
     */
    @NotEmpty(message = "事件类别不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-3]$", message = "网格类别值必须为1-3", groups = {Insert.class, Update.class})
    private String eventType;
    /**
     * 纠纷小类(字典表type=event_category)
     */
    @NotEmpty(message = "纠纷小类不可为空", groups = {Insert.class, Update.class})
    @Length(max = 36, message = "纠纷小类字符长度不可超过36", groups = {Insert.class, Update.class})
    private String eventTypeId;
    /**
     * 层id
     */
    private String floorId;
    /**
     * 网格id
     */
    private String gardenId;
    /**
     * 主键
     */
    @NotEmpty(message = "主键不可为空", groups = {Insert.class, Update.class})
    private String id;
    /**
     * 发生时间
     */
    @NotEmpty(message = "发生时间不可为空", groups = {Insert.class, Update.class})
    private String occurrenceTime;
    /**
     * 上报人所属网格
     */
    private String reportingGarden;
    /**
     * 上报人
     */
    @NotEmpty(message = "上报人不可为空", groups = {Insert.class, Update.class})
    @Length(max = 50, message = "上报人字符长度不可超过50", groups = {Insert.class, Update.class})
    private String reportingName;
    /**
     * 上报所属单位
     */
//    @NotEmpty(message = "上报所属单位不可为空", groups = {Insert.class, Update.class})
    private String reportingUnit;

    @NotEmpty(message = "受理人姓名不可为空", groups = {Insert.class, Update.class})
    @Length(max = 50, message = "上报人字符长度不可超过10", groups = {Insert.class, Update.class})
    private String eventName;
//    @NotEmpty(message = "受理人电话不可为空", groups = {Insert.class, Update.class})
    @Length(max = 14, message = "上报人电话字符长度不可超过14", groups = {Insert.class, Update.class})
    private String eventTel;
    /**
     * 风险等级，
     * 1.纠纷事实清楚，权利义务关系明确，利益损害轻微、争议不大，经调解可达成口头协议或可即时履行协议的矛盾纠纷。
     * 2.公民之间、公民与法人以及其他社会组织之间发生的涉案人数较少，涉案金额较低的矛盾纠纷
     * 3.易发多发于邻里之间的小摩擦、日常生活中的小误会、轻微损害赔偿、侵权等领域的矛盾纠纷
     */
    @NotEmpty(message = "风险等级不可为空", groups = {Insert.class, Update.class})
//    @Pattern(regexp = "^[1-3]$", message = "风险等级值必须为1-3", groups = {Insert.class, Update.class})
    private String riskLevel;
    /**
     * 事件状态: 1已办结 2处理中
     */
    @NotEmpty(message = "事件状态不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-2]$", message = "事件状态值必须为1-2", groups = {Insert.class, Update.class})
    private String status;

    /**
     * 风险因子名称
     */
    private String riskName;
    /**
     * 所属街道编码
     */
    @NotEmpty(message = "所属街道编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "所属街道格式异常", groups = {Insert.class, Update.class})
    private String streetCode;
    /**
     * 督办时间
     */
    private String supervisionTime;
    /**
     * 单元id
     */
    private String unitId;
    /**
     * 是否预警 1:正常 2:督办 3:预警 4:告警
     */
    private String isEarlyWarning;
    /**
     * 事件来源 1:自建pc 2:自建手机 3:对接
     */
    private String eventSource;
    /**
     * 扫描状态 0:修噶或新增后等待扫描 1:已扫描
     */
    private Integer isScanned;
    /**
     * 是否受理 0:未受理 1:已受理
     */
    private Integer isAcceptance;
    /**
     * 扫描时间
     */
    private String scanningTime;
    /**
     * 地市对接id
     */
    private String dockingId;
    /**
     * 告警时间
     */
    private String alarmTime;
    @NotEmpty(message = "appid不可为空", groups = {Insert.class, Update.class})
    private String appid;
    /**
     * 添加状态
     */
    private String type;
    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;
    /**
     * 是否涉众(0：否，1：是)'
     */
    @NotEmpty(message = "是否涉众不可为空", groups = {Insert.class, Update.class})
    private String isInvolveEveryone;
    /**
     * 涉众人数范围（0：5-30人，1：31-300人，2：301以上）
     */
    private String isInvolveEveryoneCount;

    public String getRiskName() {
        return riskName;
    }

    public void setRiskName(String riskName) {
        this.riskName = riskName;
    }

    public String getAddress() {
        return address;
    }

    public String getIsInvolveEveryone() {
        return isInvolveEveryone;
    }

    public void setIsInvolveEveryone(String isInvolveEveryone) {
        this.isInvolveEveryone = isInvolveEveryone;
    }

    public String getIsInvolveEveryoneCount() {
        return isInvolveEveryoneCount;
    }

    public void setIsInvolveEveryoneCount(String isInvolveEveryoneCount) {
        this.isInvolveEveryoneCount = isInvolveEveryoneCount;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getBuildingId() {
        return buildingId;
    }

    public void setBuildingId(String buildingId) {
        this.buildingId = buildingId;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCommunityCode() {
        return communityCode;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }

    public String getCompleteTime() {
        return completeTime;
    }

    public void setCompleteTime(String completeTime) {
        this.completeTime = completeTime;
    }

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventTel() {
        return eventTel;
    }

    public void setEventTel(String eventTel) {
        this.eventTel = eventTel;
    }

    public String getDisputeDescription() {
        return disputeDescription;
    }

    public void setDisputeDescription(String disputeDescription) {
        this.disputeDescription = disputeDescription;
    }

    public String getDoorplateId() {
        return doorplateId;
    }

    public void setDoorplateId(String doorplateId) {
        this.doorplateId = doorplateId;
    }

    public String getEarlyWarningTime() {
        return earlyWarningTime;
    }

    public void setEarlyWarningTime(String earlyWarningTime) {
        this.earlyWarningTime = earlyWarningTime;
    }

    public String getEventCategoryId() {
        return eventCategoryId;
    }

    public void setEventCategoryId(String eventCategoryId) {
        this.eventCategoryId = eventCategoryId;
    }

    public String getEventCode() {
        return eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }

    public String getEventType() {
        return eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventTypeId() {
        return eventTypeId;
    }

    public void setEventTypeId(String eventTypeId) {
        this.eventTypeId = eventTypeId;
    }

    public String getFloorId() {
        return floorId;
    }

    public void setFloorId(String floorId) {
        this.floorId = floorId;
    }

    public String getGardenId() {
        return gardenId;
    }

    public void setGardenId(String gardenId) {
        this.gardenId = gardenId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOccurrenceTime() {
        return occurrenceTime;
    }

    public void setOccurrenceTime(String occurrenceTime) {
        this.occurrenceTime = occurrenceTime;
    }

    public String getReportingGarden() {
        return reportingGarden;
    }

    public void setReportingGarden(String reportingGarden) {
        this.reportingGarden = reportingGarden;
    }

    public String getReportingName() {
        return reportingName;
    }

    public void setReportingName(String reportingName) {
        this.reportingName = reportingName;
    }

    public String getReportingUnit() {
        return reportingUnit;
    }

    public void setReportingUnit(String reportingUnit) {
        this.reportingUnit = reportingUnit;
    }

    public String getRiskLevel() {
        return riskLevel;
    }

    public void setRiskLevel(String riskLevel) {
        this.riskLevel = riskLevel;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getSupervisionTime() {
        return supervisionTime;
    }

    public void setSupervisionTime(String supervisionTime) {
        this.supervisionTime = supervisionTime;
    }

    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public String getIsEarlyWarning() {
        return isEarlyWarning;
    }

    public void setIsEarlyWarning(String isEarlyWarning) {
        this.isEarlyWarning = isEarlyWarning;
    }

    public String getEventSource() {
        return eventSource;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public Integer getIsScanned() {
        return isScanned;
    }

    public void setIsScanned(Integer isScanned) {
        this.isScanned = isScanned;
    }

    public Integer getIsAcceptance() {
        return isAcceptance;
    }

    public void setIsAcceptance(Integer isAcceptance) {
        this.isAcceptance = isAcceptance;
    }

    public String getScanningTime() {
        return scanningTime;
    }

    public void setScanningTime(String scanningTime) {
        this.scanningTime = scanningTime;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getAlarmTime() {
        return alarmTime;
    }

    public void setAlarmTime(String alarmTime) {
        this.alarmTime = alarmTime;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }
}
