package com.scpyun.platform.jilinsscgsdp.enums;

public enum HousingType {
        /** 自住 */
        SELF_OCCUPIED(1, "自住"),

        /** 租住 */
        RENTED(2, "租住"),

        /** 借住 */
        TEMPORARY_STAY(3, "借住"),

        /** 其他 */
        OTHERS(4, "其他");

        private final int code;
        private final String description;

        HousingType(int code, String description) {
            this.code = code;
            this.description = description;
        }

        /**
         * 根据编码获取住房类型描述
         * @param code 住房类型编码
         * @return 对应的住房类型描述，如果没有匹配则返回"未知类型"
         */
        public static String getDescriptionByCode(int code) {
            for (HousingType type : HousingType.values()) {
                if (type.code == code) {
                    return type.description;
                }
            }
            return "未知类型";
        }

        /**
         * 根据描述获取编码
         * @param description 住房类型描述
         * @return 对应的编码，如果没有匹配则返回-1
         */
        public static int getCodeByDescription(String description) {
            for (HousingType type : HousingType.values()) {
                if (type.description.equals(description)) {
                    return type.code;
                }
            }
            return -1;
        }

        // Getter方法
        public int getCode() {
            return code;
        }

        public String getDescription() {
            return description;
        }

        /**
         * 判断编码是否有效
         * @param code 待验证的编码
         * @return 如果编码对应已知住房类型返回true，否则false
         */
        public static boolean isValidCode(int code) {
            for (HousingType type : HousingType.values()) {
                if (type.code == code) {
                    return true;
                }
            }
            return false;
        }

}
