package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventFlowLogInsertVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api("重点领域")
@Service("FocusAreaNewForManage")
public class FocusAreaNewForManage {

    @Autowired
    CommonService commonService;

    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.FocusAreaNewTaskDao.";




    @ApiOperation(value = "重点领域-按月统计", desc = "重点领域-按月统计",nologin = true)
    public void insertFocusArea() {
        List<Map<String,Object>> areaList = commonService.findList(nameSpace + "getAreaList", null);

        // 获取所有的纠纷大类
        List<Map<String,Object>> eventCategoryList = commonService.findList(nameSpace + "getEventCategoryList", null);

        LocalDate today = LocalDate.now();
        String current_month = today.format(DateTimeFormatter.ofPattern("MM"));

        String current_year = today.format(DateTimeFormatter.ofPattern("yyyy"));

        if(areaList!=null && areaList.size()>0){
            for (Map<String, Object> parent_item : areaList) {
                for (Map<String, Object> item : eventCategoryList) {
                    item.put("area_id",parent_item.get("area_id"));
                    // 获取上一月各纠纷大类的 矛盾数量
                    int lastMonthCount = commonService.getObject(nameSpace + "getLastMonthCount", item);
                    // 获取当前月各纠纷大类的 矛盾数量
                    int currentMonthCount = commonService.getObject(nameSpace + "getCurrentMonthCount", item);
                    // 计算环比增长率
                    double res;
                    if (lastMonthCount == 0) {
                        res = currentMonthCount == 0 ? 0 : 100;
                    } else {
                        res = ((double)(currentMonthCount - lastMonthCount) / lastMonthCount) * 100;
                    }
                    int resInt = (int)Math.round(res);
                    if(resInt>30 && currentMonthCount>15){
                        Map<String,Object> param=new HashMap<>();
                        param.put("year",current_year);
                        param.put("month",current_month);
                        param.put("event_category_id",item.get("value"));
                        param.put("growth_rate",resInt);
                        param.put("data_type","0");
                        param.put("event_count",currentMonthCount);
                        param.put("area_code",parent_item.get("area_id"));
                        commonService.insert(nameSpace + "insertFocusAreaNew", param);
                    }
                }
            }
        }
    }

    @ApiOperation(value = "重点领域-按年统计", desc = "重点领域-按年统计",nologin = true)
    public void insertFocusAreaWithYear() {

        List<Map<String,Object>> areaList = commonService.findList(nameSpace + "getAreaList", null);

        // 获取所有的纠纷大类
        List<Map<String,Object>> eventCategoryList = commonService.findList(nameSpace + "getEventCategoryList", null);

        LocalDate today = LocalDate.now();
        String current_month = today.format(DateTimeFormatter.ofPattern("MM"));

        String current_year = today.format(DateTimeFormatter.ofPattern("yyyy"));

        if(areaList!=null && areaList.size()>0){
            for (Map<String, Object> parent_item : areaList) {
                for (Map<String, Object> item : eventCategoryList) {
                    item.put("area_id",parent_item.get("area_id"));
                    // 获取上一年各纠纷大类的 矛盾数量
                    int lastYearCount = commonService.getObject(nameSpace + "getLastYearCount", item);
                    // 获取当前年各纠纷大类的 矛盾数量
                    int currentYearCount = commonService.getObject(nameSpace + "getCurrentYearCount", item);
                    // 计算环比增长率
                    double res;
                    if (lastYearCount == 0) {
                        res = currentYearCount == 0 ? 0 : 100;
                    } else {
                        res = ((double)(currentYearCount - lastYearCount) / lastYearCount) * 100;
                    }
                    int resInt = (int)Math.round(res);
                    if(resInt>50 && currentYearCount>15){
                        Map<String,Object> param=new HashMap<>();
                        param.put("year",current_year);
                        param.put("month",current_month);
                        param.put("event_category_id",item.get("value"));
                        param.put("growth_rate",resInt);
                        param.put("data_type","1");
                        param.put("event_count",currentYearCount);
                        param.put("area_code",parent_item.get("area_id"));
                        commonService.insert(nameSpace + "insertFocusAreaNew", param);
                    }
                }
            }
        }
    }

    @ApiOperation(value = "重点领域列表", desc = "重点领域列表")
    public Page getFocusAreaPage(Page page) {
        return commonService.findPage(nameSpace + "getFocusAreaPage", page);
    }

    @ApiOperation(value = "重点领域列表-矛盾列表(详情)", desc = "重点领域列表-矛盾列表(详情)")
    public Page getEventaPageList(Page page) {
        Map params = page.getParams();
        if(params.get("data_type").equals("0")){
            String year = (String) params.get("year");
            String month = (String) params.get("month");
            String yearMonth = year + "-" + month;
            LocalDate startDate = LocalDate.parse(yearMonth + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate endDate = startDate.withDayOfMonth(startDate.lengthOfMonth());
            String occurrenceTimeStart = startDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String occurrenceTimeEnd = endDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            params.put("occurrenceTimeStart",occurrenceTimeStart);
            params.put("occurrenceTimeEnd",occurrenceTimeEnd);
        }else{
            String year = (String) params.get("year");
            params.put("occurrenceTimeStart",year+"-01-01");
            params.put("occurrenceTimeEnd",year+"-12-31");
        }
        Page<ReqEventFlowLogInsertVo> returnPage = commonService.findPage(nameSpace + "getEventaPageList", page);
        return returnPage;
    }



}
