package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.DataSourceSwitcher;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Api("人员变更日志")
@Service("gridUserLogService")
public class GridUserLogServiceImpl {

    @Resource
    CommonService commonService;

    private String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.userGrid.";
   
	private final String module_nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.gridModule.";

    @ApiOperation(value = "人员信息管理Log")
    public List<Map<String,Object>> findUserLogByCardnoList(Map<String,Object> map) {
        if(StringUtils.isEmpty(map.get("cardno"))){
            throw new CustomException("缺少参数！");
        }
        DataSourceSwitcher.setMaster();
    	//DataSourceSwitcher.setShardingSphere("ShardingDataSource");
        return commonService.findList(nameSpace + "findUserLogByCardnoList",map);
    }
    @ApiOperation(value = "户Log")
    public List<Map<String,Object>> findUserLogByDoorplateList(Map<String,Object> map) {
        if(StringUtils.isEmpty(map.get("doorplate_id"))){
            throw new CustomException("缺少参数！");
        }
		DataSourceSwitcher.setMaster();
    	//DataSourceSwitcher.setShardingSphere("ShardingDataSource");
    	Map cityInfo = commonService.getObject(module_nameSpace+"getCityIdFromUnitOrBuildingOrDoorplate", map);
    	map.putAll(cityInfo);
        return commonService.findList(nameSpace + "findUserLogByDoorplateList",map);
    }
}
