package com.scpyun.platform.jilinsscgsdp.task.impl;

import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.platform.jilinsscgsdp.service.impl.FocusAreasServiceImpl;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.awt.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

@Component
public class FocusAreasChainTask {

    RedissonClient redissonClient = SpringContextHolder.getBean(RedissonClient.class);

    @Resource
    FocusAreasServiceImpl areasOcusService;


    @Scheduled(cron = "0 */30 * * * ?")
    public void doChainCompute() {
        RLock rLock = redissonClient.getLock("zfw:areasFocusChainTask");
        try {
            if (rLock.tryLock(30,60, TimeUnit.SECONDS)) {
                areasOcusService.areasOcusCount();
//                TimeUnit.SECONDS.sleep(10);
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }else {
                UnifyLogger.parent("不是当前前程锁不允许释放锁", UnifyLogger.Level.INFO);
            }
        }
    }
}
