package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.EventCategory;
import com.scpyun.platform.jilinsscgsdp.bean.entity.EventCategoryOther;
import com.scpyun.platform.jilinsscgsdp.bean.entity.EventRepeatble;
import com.scpyun.platform.jilinsscgsdp.bean.entity.EventRepeatbleInfo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventFlowLogInsertVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventOpinionFindVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ResEventOpinionVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Api("系统去重")
@Service("EventDealRepeatableServiceImpl")
public class EventDealRepeatableServiceImpl {

    @Autowired
    CommonService commonService;

    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.EventRepeatbleDao.";

    @ApiOperation(value = "待去重列表")
    public Page<EventRepeatble> selectEventRepeatbleList(Page<EventRepeatble> page) {
        Page<EventRepeatble> eventRepeatbleList = commonService.findPage(nameSpace + "selectEventRepeatbleList", page);
        return eventRepeatbleList;
    }

    @ApiOperation(value = "详情", desc = "详情")
    public List<EventRepeatbleInfo> eventRepeatbleInfoList(EventRepeatbleInfo eventRepeatbleInfo) {
        List<EventRepeatbleInfo> eventRepeatbleInfoList = commonService.findList(nameSpace + "eventRepeatbleInfoList", eventRepeatbleInfo);
        return eventRepeatbleInfoList;
    }

    @ApiOperation(value = "删除重复项", desc = "删除重复项")
    public void updateEventRepeatbleInfo(EventRepeatbleInfo eventRepeatbleInfo) {
        commonService.update(nameSpace+"updateEventRepeatbleInfo",eventRepeatbleInfo);
    }




}
