package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.google.common.collect.Maps;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqGardenStatisticsVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqIdVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ResCommunityStatisticsVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ResGardenStatisticsVo;
import com.scpyun.platform.jilinsscgsdp.utils.DateUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @version V1.0.0
 * @Title: AppStatisticsImpl
 * @Package com.scpyun.platform.jilinsscgsdp.service.impl
 * @Description: 移动端关于统计的接口
 * @author: guojiucoder
 * @date: 2024/8/15 16:17
 */
@Api("app服务")
@Service("appStatistics")
public class AppStatisticsImpl {
    @Resource
    private CommonService commonService;

    @ApiOperation(value = "移动端根据社区、网格、楼宇统计", desc = "移动端根据社区、网格、楼宇统计")
    public ResGardenStatisticsVo getStatisticsByCgbId(ReqGardenStatisticsVo vo) {
        String communityId = vo.getCommunityId();
        String gardenId = vo.getGardenId();
        String buildingId = vo.getBuildingId();
        Map<String, Object> param = Maps.newHashMap();
        Map<String, Object> result;
        ResGardenStatisticsVo res = new ResGardenStatisticsVo();
        if (null != communityId && !"".equals(communityId)) {
            param.put("communityId", communityId);
        }
        if (null != gardenId && !"".equals(gardenId)) {
            param.put("gardenId", gardenId);
        }
        if (null != buildingId && !"".equals(buildingId)) {
            param.put("buildingId", buildingId);
        }
        //楼数
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectBuildingNumByGardenId", param);
        Integer buildingNum = Integer.parseInt(result.get("num").toString());
        res.setBuildingNum(buildingNum);
        //房屋数
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectDoorplateNumByGardenId", param);
        Integer houseNum = Integer.parseInt(result.get("num").toString());
        res.setHouseNum(houseNum);
        //人口数
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectJlGridUserByGardenId", param);
        Integer population = Integer.parseInt(result.get("num").toString());
        res.setPopulation(population);
        //男性数
        param.put("sex", "1");
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectJlGridUserByGardenId", param);
        Integer manNum = Integer.parseInt(result.get("num").toString());
        res.setManNum(manNum);
        //女性数
        param.put("sex", "2");
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectJlGridUserByGardenId", param);
        Integer womanNum = Integer.parseInt(result.get("num").toString());
        res.setWomanNum(womanNum);
        //自住数量
        param.remove("sex");
        param.put("livingCondition", "1");
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectJlGridUserByGardenId", param);
        Integer selfNum = Integer.parseInt(result.get("num").toString());
        res.setSelfNum(selfNum);
        //常住数量
        param.remove("livingCondition");
        param.put("userType", "0");
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectJlGridUserByGardenId", param);
        Integer residentNum = Integer.parseInt(result.get("num").toString());
        res.setResidentNum(residentNum);
        //户籍数量
        param.remove("userType");
        param.put("hujiType", "0");
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectJlGridUserByGardenId", param);
        Integer registerNum = Integer.parseInt(result.get("num").toString());
        res.setRegisterNum(registerNum);
        return res;
    }

    @ApiOperation(value = "移动端根据社区统计", desc = "移动端根据社区统计", nologin = true)
    public ResCommunityStatisticsVo getStatisticsByCommunityId(ReqIdVo vo) {
        ResCommunityStatisticsVo res = new ResCommunityStatisticsVo();
        String communityId = vo.getId();
        Map<String, Object> param = Maps.newHashMap();
        param.put("communityId", communityId);
        Map<String, Object> result;
        //人口数
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectJlGridUserByGardenId", param);
        Integer population = Integer.parseInt(result.get("num").toString());
        res.setPopulation(population);
        //房屋数
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.selectDoorplateNumByGardenId", param);
        Integer houseNum = Integer.parseInt(result.get("num").toString());
        res.setHouseNum(houseNum);
        //获取当年年度
        String currentYear = DateUtil.getCurrentYear();
        //事件类别 1:直报事件 2:矛盾纠纷 3:舆情观察
        //社区本年度矛盾数
        param.put("currentYear", currentYear);
        param.put("eventType", "2");
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.event.findEventCount", param);
        Integer contradictionNum = Integer.parseInt(result.get("num").toString());
        res.setContradictionNum(contradictionNum);
        //社区本年度事件数
        param.put("eventType", "1");
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.event.findEventCount", param);
        Integer eventNum = Integer.parseInt(result.get("num").toString());
        res.setEventNum(eventNum);
        //社区本年度舆情数
        param.put("eventType", "3");
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.event.findEventCount", param);
        Integer publicSentimentNum = Integer.parseInt(result.get("num").toString());
        res.setPublicSentimentNum(publicSentimentNum);
        //物件数
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.findSubstanceCount", param);
        Integer substanceNum = Integer.parseInt(result.get("num").toString());
        res.setSubstanceNum(substanceNum);
        //社会组织数
        result = commonService.getObject("com.scpyun.platform.standard.jilinsscgsdp.statistics.findSocietyCount", param);
        Integer societyNum = Integer.parseInt(result.get("num").toString());
        res.setSocietyNum(societyNum);
        //党组织数
        result = commonService.getObject("com.scpyun.platform.standard.dq.partyandmassservice.findOrgNum", param);
        Integer orgNum = Integer.parseInt(result.get("num").toString());
        res.setOrgNum(orgNum);
        return res;
    }
}
