package com.scpyun.platform.jilinsscgsdp.enums;

public enum PoliticalStatusEnum {
    // 枚举值顺序与编号保持一致
    MASS(1, "群众"),
    COMMUNIST_PARTY_MEMBER(2, "共产党员"),
    CYL_MEMBER(3, "共产主义青年团团员"),
    KUOMINTANG_REVOLUTIONARY_COMMITTEE(4, "国民党革命委员会会员"),
    DEMOCRATIC_LEAGUE(5, "民主同盟盟员"),
    CHINA_DEMOCRATIC_NATIONAL_CONSTRUCTION_ASSOCIATION(6, "民主建国会会员"),
    CHINA_ASSOCIATION_FOR_PROMOTING_DEMOCRACY(7, "民主促进会会员"),
    CHINESE_PEASANTS_AND_WORKERS_DEMOCRATIC_PARTY(8, "农工民主党党员"),
    ZHIGONG_PARTY(9, "致公党党员"),
    JIU_SAN_SOCIETY(10, "九三学社社员"),
    TAIWAN_DEMOCRATIC_SELF_GOVERNMENT_LEAGUE(11, "台湾民主自治同盟盟员"),
    INDEPENDENT_DEMOCRAT(12, "无党派民主人士");

    private final int code;
    private final String description;

    PoliticalStatusEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 根据编码获取政治面貌描述
     * @param code 政治面貌编码
     * @return 对应的政治面貌描述，如果没有匹配则返回"未知政治面貌"
     */
    public static String getDescriptionByCode(int code) {
        for (PoliticalStatusEnum status : PoliticalStatusEnum.values()) {
            if (status.code == code) {
                return status.description;
            }
        }
        return "未知政治面貌";
    }

    /**
     * 根据描述获取编码
     * @param description 政治面貌描述
     * @return 对应的编码，如果没有匹配则返回-1
     */
    public static int getCodeByDescription(String description) {
        for (PoliticalStatusEnum status : PoliticalStatusEnum.values()) {
            if (status.description.equals(description)) {
                return status.code;
            }
        }
        return -1;
    }

    // Getter方法
    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }
}
