package com.scpyun.platform.jilinsscgsdp.utils;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.scpyun.base.core.utils.UUIDUtil;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.MaterialImp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class MaterialFileListener extends AnalysisEventListener<MaterialImp> {
    private static final Logger log = LoggerFactory.getLogger(MaterialFileListener.class);
    private static final int BATCH_COUNT = 200;
    private List<MaterialImp> cached = new ArrayList<>(BATCH_COUNT);
    private AtomicInteger insertCount = new AtomicInteger(0);
    private AtomicInteger updateCount = new AtomicInteger(0);
    private AtomicInteger errorCount = new AtomicInteger(0);

    private CommonService commonService;
    private String namespace;
    private Map<String,Object> param;
    private List<String> errInfo = new ArrayList<>();

    public MaterialFileListener(CommonService commonService, String namespace, Map<String,Object> param) {
        this.commonService = commonService;
        this.namespace = namespace;
        this.param = param;
    }

    @Override
    public void invoke(MaterialImp data, AnalysisContext context) {
        try {
            cached.add(data);
            if (cached.size() >= BATCH_COUNT) {
                saveBatch();
                cached.clear();
            }
        } catch (Exception e) {
            errorCount.incrementAndGet();
            log.error("解析物料导入行异常", e);
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        if (!cached.isEmpty()) {
            saveBatch();
            cached.clear();
        }
    }

    private void saveBatch() {
        for (MaterialImp m : cached) {
            try {
                Map<String,Object> q = new HashMap<>();
                q.put("material_code", m.getMaterial_code());
                Map<String,Object> exists = commonService.getObject(namespace + "getByCode", q);
                Map<String,Object> row = new HashMap<>();
                row.put("category_Code", m.getCategory_Code());
                row.put("category_Name", m.getCategory_Name());
                row.put("material_code", m.getMaterial_code());
                row.put("material_name", m.getMaterial_name());
                row.put("material_spec", m.getMaterial_spec());
                row.put("unit", m.getUnit());
                row.put("unit_price", m.getUnit_price());
                row.put("storage_location", m.getStorage_location());
                row.put("min_stock", m.getMin_stock());
                row.put("max_stock", m.getMax_stock());
                row.put("can_borrow", m.getCan_borrow());
                row.put("material_desc", m.getMaterial_desc());
                row.put("order_no", 0);
                if (exists == null) {
                    row.put("id", UUIDUtil.getUUID());
                    commonService.insert(namespace + "insert", row);
                    insertCount.incrementAndGet();
                } else {
                    row.put("id", exists.get("id"));
                    commonService.update(namespace + "update", row);
                    updateCount.incrementAndGet();
                }
            } catch (Exception ex) {
                errorCount.incrementAndGet();
                errInfo.add(m.getMaterial_code() + ":" + ex.getMessage());
            }
        }
    }

    public Map<String,Object> getResult() {
        Map<String,Object> r = new HashMap<>();
        r.put("insert", insertCount.get());
        r.put("update", updateCount.get());
        r.put("error", errorCount.get());
        r.put("errInfo", String.join(",", errInfo));
        return r;
    }
}


