package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventFlowLogInsertVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventInsertVo;
import com.scpyun.platform.jilinsscgsdp.constant.NumberConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author liu
 * @Date 2024/6/18 13:22
 * @PackageName:com.scpyun.platform.jilinsscgsdp.service.impl
 * @ClassName: StatisticsServiceImpl
 * @Description: TODO
 * @Version 1.0
 */
@Api("首页统计")
@Service("statisticsService")
public class StatisticsServiceImpl {
    @Autowired
    CommonService commonService;
    private final String eventNameSpace = "com.scpyun.platform.standard.jilinsscgsdp.event.";
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.statistics.";
    private final String nameSpaceSys = "com.scpyun.platform.standard.jilinsscgsdp.sys.";

    @ApiOperation(value = "查询待处理事件", desc = "查询待处理事件")
    public Page<ReqEventFlowLogInsertVo> selectAgencyHandlingList(Page<ReqEventFlowLogInsertVo> map) {
        Page<ReqEventFlowLogInsertVo> eventList;
        Map<String, Object> params = map.getParams();
        String gridName = commonService.getObject(nameSpaceSys + "getRoleUserNew", params);
        if (StringUtils.isNotEmpty(gridName)) {
            eventList = commonService.findPage(nameSpace + "selectAgencyHandlingList", map);
        } else {
            eventList = commonService.findPage(nameSpace + "findEventOfficeStatusList", map);
        }
        return eventList;
    }

    @ApiOperation(value = "查询首页矛盾总数量", desc = "查询首页矛盾总数量")
    public Map<String, Object> getCountNumber(Page<Map<String,Object>> page){

        Map<String, Object> result = new HashMap<>();
        // 获取当前用户是否是横向部门
        Map<String, Object> params = (Map<String, Object>) page.getParams();
        Map<String, Object> user = (Map<String, Object>) params.get("_user");
        String fax = commonService.getObject(eventNameSpace + "getFax", user.get("company_id"));
        if (StringUtils.isNotEmpty(fax)) {// 横向部门
            params.put("fax", fax);
        }

        return commonService.getObject(nameSpace + "getCountNumber", params);
    }
}
