define(['./utils/loader', './m_route'], function (loader, routeUse) {

    var extend = {};
    extend.enviro = '${server.enviro}';
    let pathBase = "";
    if (window.location.pathname.indexOf('/scpcw/') > 0) {
        pathBase = window.location.pathname.substring(0, window.location.pathname.indexOf('/scpcw/'))
    }
    // 路由数据处理
    function deaRoute (routes){
        const arr = routes.map(v => {
            if (v.component) {
                v.component = loader(pathBase + v.component)
            }
            if (v.children) {
                v.children.map(m=> {
                    if (m.component) {
                        m.component = loader(pathBase + m.component)
                    }
                    return m
                })
            }
            return v
        })
        return arr
    }
    const routes = deaRoute(routeUse.routes)
    extend.document = routeUse.title
    // 路由文件，申明路由，哪些页面的。
    extend.router = {
        routes: routes,
        dynamicBasePath: '/'
    }

    extend.require = {
        config:{
            urlArgs: 'v=' + (new Date()).getTime(),
            paths: {
                'vant': '../src/libs/vant2_12/index.min',
                'flexible': '../src/libs/vant2_11/flexible',
                'hd-mobile-plugin-gather': 'http://base.tripln.com/hd-mobile-plugin-gather/hd-mobile-plugin-gather.umd.min',
                'scpcw-mobile-plugin': 'http://base.tripln.com/scpcw-mobile-plugin/scpcw-mobile-plugin.umd.min',
            },
            shim: {
                'vant': ['vue'],
            }
        },
        require_param1:['vue','vant','hd-mobile-plugin-gather','scpcw-mobile-plugin','flexible','css!../src/libs/vant2_12/index.css','css!http://base.tripln.com/hd-mobile-plugin-gather/hd-mobile-plugin-gather.css','css!https://base.tripln.com/hd-mobile-plugin-gather/hd-mobile-plugin-gather.css'],
        require_param2:function(Vue,vant,hdMobilePluginGather,scpcwMobilePlugin){
            Vue.use(vant);
            Vue.use(hdMobilePluginGather.default);
            Vue.use(scpcwMobilePlugin.default);
            Vue.mixin({
                data() {
                    return {
                        $parentData: {},
                        scrollNum: null
                    }
                },
                created(){
                    this.$parentData = this.$data.$parentData
                    // this.$nextTick(() => {
                    // if (document.querySelector('.framework-navigation-main')) {
                    // document.querySelector('.framework-navigation-main').scrollTop = 0
                    // }
                    // })
                },
                mounted(){
                },
                activated() {
                    this.$nextTick(() => {
                        setTimeout(() => {
                            document.querySelector('.framework-navigation-main').scrollTop = this.scrollNum
                        }, 0);
                    });
                },
            });
        }
    };
    return extend
})
