package com.scpyun.platform.jilinsscgsdp.task.impl;

import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.task.JlKeyPerson;
import com.scpyun.platform.jilinsscgsdp.bean.vo.task.ReqTaskVo;
import com.scpyun.platform.jilinsscgsdp.constant.task.Constant;
import com.scpyun.platform.jilinsscgsdp.constant.task.NumberConstant;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author liu
 * @Date 2024/6/5 15:05
 * @PackageName:com.scpyun.platform.jilinsscgsdp.task.impl
 * @ClassName: AutoSynchronizeDataTask
 * @Description: TODO
 * @Version 1.0
 */
@Component
public class KeyPersonTask {

    CommonService commonService = SpringContextHolder.getBean(CommonService.class);
    RedissonClient redissonClient = SpringContextHolder.getBean(RedissonClient.class);
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.keypersonTask.";

    @Scheduled(cron = "0 */5 * * * ?")
    public void KeyPersonUserTask() {
        RLock rLock = redissonClient.getLock("jilinexchange:KeyPersonUserTask");
        ReqTaskVo task = new ReqTaskVo();
        try {
            if (rLock.tryLock(0, TimeUnit.SECONDS)) {
                List<JlKeyPerson> KeyPersonList = commonService.findList(nameSpace + "selectKeyPersonTaskList", null);
                for (JlKeyPerson KeyPerson : KeyPersonList) {
                    try {
                        task.setOperateType(NumberConstant.ONE_STRING);
                        switch (Constant.TypeEnum.getType(KeyPerson.getType())) {
                            case INSERT:
                                commonService.insert(nameSpace + "insertKeyPersonTask", KeyPerson);
                                break;
                            case UPDATE:
                                commonService.update(nameSpace + "updateKeyPersonTask", KeyPerson);
                                break;
                            case DELETE:
                                commonService.update(nameSpace + "deleteKeyPersonTask", KeyPerson);
                                break;
                            default:
                                throw new Exception("type 异常！");
                        }
                    } catch (Exception e) {
                        UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
                        task.setOperateType(NumberConstant.TWO_STRING);
                    } finally {
                        task.setIntId(KeyPerson.getIntId());
                        task.setAppid(KeyPerson.getAppid());
                        task.setDockingId(KeyPerson.getDockingId());
                        commonService.update(nameSpace + "updateOperateTypeKeyPerson", task);
                    }
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }

    @Scheduled(cron = "0 */5 * * * ?")
    public void KeyPersonHighlyConcernedRelTask() {
        RLock rLock = redissonClient.getLock("jilinexchange:KeyPersonHighlyConcernedRelTask");
        ReqTaskVo task = new ReqTaskVo();
        try {
            if (rLock.tryLock(0, TimeUnit.SECONDS)) {
                List<JlKeyPerson> KeyPersonList = commonService.findList(nameSpace + "selectKeyPersonHighlyConcernedRelTaskList", null);
                for (JlKeyPerson KeyPerson : KeyPersonList) {
                    try {
                        task.setOperateType(NumberConstant.ONE_STRING);
                        switch (Constant.TypeEnum.getType(KeyPerson.getType())) {
                            case INSERT:
                                commonService.insert(nameSpace + "insertKeyPersonHighlyConcernedRelTask", KeyPerson);
                                break;
                            case UPDATE:
                                commonService.update(nameSpace + "updateKeyPersonHighlyConcernedRelTask", KeyPerson);
                                break;
                            case DELETE:
                                commonService.update(nameSpace + "deleteKeyPersonHighlyConcernedRelTask", KeyPerson);
                                break;
                            default:
                                throw new Exception("type 异常！");
                        }
                    } catch (Exception e) {
                        UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
                        task.setOperateType(NumberConstant.TWO_STRING);
                    } finally {
                        task.setIntId(KeyPerson.getIntId());
                        task.setAppid(KeyPerson.getAppid());
                        task.setDockingId(KeyPerson.getDockingId());
                        commonService.update(nameSpace + "updateOperateTypeKeyPersonHighlyConcernedRel", task);
                    }
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }
}
