package com.scpyun.platform.jilinsscgsdp.utils;


import java.util.List;
import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Path.Node;
import javax.validation.Validator;

import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.SpringContextHolder;

import cn.hutool.core.util.ReflectUtil;

/**
 * @author zang
 * @version 1.0.0
 * @description 非接口使用参数校验
 * @since 2023/9/20 15:40
 */
public class ValidatorUtil {
    private static final Validator VALID = SpringContextHolder.getBean(Validator.class);

    public static <T> void validate(T object, Class<?>... groups) {
        Set<ConstraintViolation<T>> validate = VALID.validate(object, groups);
        if (!validate.isEmpty()) {
        	StringBuilder _sb=new StringBuilder();
        	validate.stream().forEach(x->{
                List<Node> nodeList = (List<Node>) ReflectUtil.getFieldValue(x.getPropertyPath(),"nodeList");
                //_sb.append(nodeList.get(nodeList.size() - 1).getName()+" "+x.getMessage());
                _sb.append(x.getMessage());
                _sb.append(".");
            });
        	throw new CustomException(_sb.toString());
        }
    }
}
