package com.scpyun.platform.jilinsscgsdp.check;

import cn.hutool.core.util.IdcardUtil;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;

import java.util.Map;

/**
 * @Author liu
 * @Date 2024/8/1 10:21
 * @PackageName:com.scpyun.platform.jilinsscgsdp.check
 * @ClassName: DutyCheckUtils
 * @Description: TODO
 * @Version 1.0
 */
public class DutyCheckUtils {
    public static void dutyCheck(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("company_id"))) {
            throw new CustomException("部门不可为空！");
        }
        if (StringUtils.isEmpty(map.get("duty"))) {
            throw new CustomException("职责不可为空！");
        }
    }

    public static void fixedCheck(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("name"))) {
            throw new CustomException("任务名称不可为空！");
        }
        if (StringUtils.isEmpty(map.get("city_id"))) {
            throw new CustomException("市id不可为空！");
        }
        if (StringUtils.isEmpty(map.get("area_id"))) {
            throw new CustomException("区id不可为空！");
        }
        if (StringUtils.isEmpty(map.get("street_id"))) {
            throw new CustomException("街道不可为空！");
        }
        if (StringUtils.isEmpty(map.get("community_id"))) {
            throw new CustomException("社区不可为空！");
        }
        if (StringUtils.isEmpty(map.get("garden_id"))) {
            throw new CustomException("网格不可为空！");
        }
        if (StringUtils.isEmpty(map.get("csc_mapjson"))) {
            throw new CustomException("地图坐标不可为空！");
        }
    }

    public static void GardenUserCheck(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("cardno"))) {
            throw new CustomException("证件号码不可为空！");
        }
        if (!IdcardUtil.isValidCard(StringUtils.toStr(map.get("cardno")))) {
            throw new CustomException("证件号码错误！");
        }
        if (StringUtils.isEmpty(map.get("city_id"))) {
            throw new CustomException("市id不可为空！");
        }
        if (StringUtils.isEmpty(map.get("area_id"))) {
            throw new CustomException("区id不可为空！");
        }
        if (StringUtils.isEmpty(map.get("street_id"))) {
            throw new CustomException("街道不可为空！");
        }
        if (StringUtils.isEmpty(map.get("community_id"))) {
            throw new CustomException("社区不可为空！");
        }
        if (StringUtils.isEmpty(map.get("garden_id"))) {
            throw new CustomException("网格不可为空！");
        }
        if (StringUtils.isEmpty(map.get("duty_id"))) {
            throw new CustomException("职责id不可为空！");
        }
        if (StringUtils.isEmpty(map.get("tel"))) {
            throw new CustomException("电话不可为空！");
        }
        if (StringUtils.toStr(map.get("tel")).length() > 11) {
            throw new CustomException("电话号错误！");
        }
        if (StringUtils.isEmpty(map.get("company_id"))) {
            throw new CustomException("部门id不可为空！");
        }
    }
}
