package com.scpyun.platform.jilinsscgsdp.bean.vo.task;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

public class ReqGardenVo extends ReqBaseVo{

    /**
     * 主键
     */
    @NotEmpty(message = "id不可为空",groups = {Insert.class,Update.class,Delete.class})
    @Length(min=1, max=200,message = "id数据长度范围1到200",groups = {Insert.class,Update.class,Delete.class})
    private String id;

    /**
     * 网格名称
     */
    @NotEmpty(message = "网格名称不可为空",groups = {Insert.class,Update.class})
    @Length(min=1, max=40,message = "网格名称数据长度范围1到40",groups = {Insert.class,Update.class})
    private String name;

    /**
     * 网格类别
     */
    @NotEmpty(message = "网格类别不可为空",groups = {Insert.class,Update.class})
    @Pattern(regexp = "^[1-2]$", message = "网格类别值必须为1或2",groups = {Insert.class,Update.class})
    private String gridType;

    /**
     * 网格坐标
     */
//    @NotEmpty(message = "网格坐标不可为空",groups = {Insert.class,Update.class})
//    @Length(min=1, max=8000,message = "网格坐标数据长度范围1到8000",groups = {Insert.class,Update.class})
    private String cscMapjsonHt;

    /**
     * 社区编码
     */
//    @NotEmpty(message = "社区编码不可为空",groups = {Insert.class,Update.class})
//    @Pattern(regexp = "^\\d{12}$", message = "社区编码格式异常",groups = {Insert.class,Update.class})
    private String communityCode;

    /**
     * 单位负责人
     */
//    @NotEmpty(message = "单位负责人不可为空",groups = {Insert.class,Update.class})
    @Length(min=1, max=40,message = "单位负责人数据长度范围1到40",groups = {Insert.class,Update.class})
    private String unitContact;

    /**
     * 单位负责人电话
     */
//    @NotEmpty(message = "单位负责人电话不可为空",groups = {Insert.class,Update.class})
    @Length(min=1, max=20,message = "单位负责人电话数据长度范围1到20",groups = {Insert.class,Update.class})
    private String contactPhone;

    /**
     * 市编码
     */
    @NotEmpty(message = "市编码不可为空",groups = {Insert.class,Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "市编码格式异常",groups = {Insert.class,Update.class})
    private String cityCode;

    /**
     * 区id
     */
//    @NotEmpty(message = "区编码不可为空",groups = {Insert.class,Update.class})
//    @Pattern(regexp = "^\\d{12}$", message = "区编码格式异常",groups = {Insert.class,Update.class})
    private String areaCode;

    /**
     * 街道编码
     */
//    @NotEmpty(message = "街道编码不可为空",groups = {Insert.class,Update.class})
//    @Pattern(regexp = "^\\d{12}$", message = "街道编码格式异常",groups = {Insert.class,Update.class})
    private String streetCode;

    /**
     * appid
     */
    @NotEmpty(message = "appid不可为空",groups = {Insert.class,Update.class,Delete.class})
    @Length(min=1, max=36,message = "appid数据长度范围1到36",groups = {Insert.class,Update.class,Delete.class})
    private String appid;

    /**
     * 社区账号
     */
    private String companyCode;

    /**
     * 地市对接id
     */
    private String dockingId;

    /**
     * 添加状态
     */
    private String type;

    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;
    
    private String grade;
    private String cscMapjson;
    private Integer intId;


    public String getCscMapjson() {
        return cscMapjson;
    }

    public void setCscMapjson(String cscMapjson) {
        this.cscMapjson = cscMapjson;
    }

    public Integer getIntId() {
        return intId;
    }

    public void setIntId(Integer intId) {
        this.intId = intId;
    }
    public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGridType() {
		return gridType;
	}

	public void setGridType(String gridType) {
		this.gridType = gridType;
	}

	public String getCscMapjsonHt() {
        return cscMapjsonHt;
    }

    public void setCscMapjsonHt(String cscMapjsonHt) {
        this.cscMapjsonHt = cscMapjsonHt;
    }

    public String getCommunityCode() {
        return communityCode;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }

    public String getUnitContact() {
        return unitContact;
    }

    public void setUnitContact(String unitContact) {
        this.unitContact = unitContact;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }
}