package com.scpyun.platform.jilinsscgsdp.service.impl;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.DataSourceSwitcher;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.bo.UserInfoBo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqMssoVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ResMssoVo;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdcardUtil;

/**
 * @version V1.0.0
 * @Title: NewGridLevelServiceImpl
 * @Package NewGridLevelServiceImpl.java
 * @Description: copy By scp-grid
 * @author: guojiucoder
 * @date: 2024/7/31 16:33
 */
@Api("新层级查询")
@Service("newGridLevelService")
public class NewGridLevelServiceImpl {

    @Autowired
    CommonService commonService;

    private String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.newgridlevel.";
    private String nameSpace_gridLevel="com.scpyun.platform.standard.jilinsscgsdp.gridLevel.";

    @ApiOperation(value = "查询机构信息", desc = "查询机构信息")
    public Map<String, Object> getCompantInfo(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("id"))) {
            throw new CustomException("缺少参数！");
        }
        DataSourceSwitcher.setSharding("sc");
        DataSourceSwitcher.setSlave();
        Map retMap = commonService.getObject(nameSpace + "getCompanyInfoById", map);
        if (retMap == null) {
            throw new CustomException("未查询到机构信息！");
        }
        return retMap;
    }

    @ApiOperation(value = "查询各个层级数据select", desc = "查询各个层级数据select")
    public List<Map<String, Object>> findGridLevelList(Map<String, Object> map) {
//        if(StringUtils.isEmpty(map.get("id"))) {
//            throw new CustomException("缺少参数！");
//        }
    	
        if (StringUtils.isEmpty(map.get("grade"))) {
            throw new CustomException("缺少参数！");
        }
        String grade = StringUtils.toString(map.get("grade"));
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        switch (grade) {
            case "3": //查询市级列表
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                list = commonService.findList(nameSpace + "findJLCityList", map);
                break;
            case "4": //查询区级列表
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                list = commonService.findList(nameSpace + "findJLAreaList", map);
                break;
            case "5": //查询街道级列表
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                list = commonService.findList(nameSpace + "findJLStreetList", map);
                break;
            case "6": //查询社区级列表
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                list = commonService.findList(nameSpace + "findJLCommunityList", map);
                break;
            case "6.5": //查询小区级列表
                list = commonService.findList(nameSpace + "findResidentialList", map);
                break;
            case "7":
                list = commonService.findList(nameSpace + "findGardenList", map);
                break;
            case "8":
                list = commonService.findList(nameSpace + "findBuildingList", map);
                break;
            default:
        }
        return list;
    }

    @ApiOperation(value = "根据社区查网格", desc = "根据社区查网格")
    public List<Map<String, Object>> findGardenForCommunityList(Map<String, Object> map) {
        List<Map<String, Object>> list = commonService.findList(nameSpace+"findGardenForCommunityList", map);
        return list;
    }

    @ApiOperation(value = "查询地图区", desc = "查询地图区")
    public List<Map<String, Object>> findAreaList(Map<String, Object> map) {
        DataSourceSwitcher.setSharding("sc");
        DataSourceSwitcher.setSlave();
        List<Map<String, Object>> list = commonService.findList(nameSpace + "findAreaList", map);
        return list;
    }

    @ApiOperation(value = "查询地图小区", desc = "查询地图小区")
    public List<Map<String, Object>> findResidentialByMapList(Map<String, Object> map) {
        return commonService.findList(nameSpace + "findResidentialByMapList", map);
    }

    @ApiOperation(value = "查询地图网格", desc = "查询地图网格")
    public List<Map<String, Object>> findGardenByMapList(Map<String, Object> map) {
        return commonService.findList(nameSpace + "findGardenByMapList", map);
    }

    @ApiOperation(value = "查询地图楼", desc = "查询地图楼")
    public List<Map<String, Object>> findBuildingByMapList(Map<String, Object> map) {
        return commonService.findList(nameSpace + "findBuildingByMapList", map);
    }

    @ApiOperation(value = "标签地图楼", desc = "标签地图楼")
    public List<Map<String, Object>> findBuildingLabelByMapList(Map<String, Object> map) {
        List<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> peopleList = commonService.findList(nameSpace + "findBuildingLabelByMapList", map);
        List<Map<String, Object>> buildingList = commonService.findList(nameSpace + "findBuildingByMapList", map);
        if (peopleList.size() == 0 || buildingList.size() == 0) return new ArrayList<Map<String, Object>>();
        for (Map<String, Object> buildingMap : buildingList) {
            for (Map<String, Object> peopleMap : peopleList) {
                if (StringUtils.toString(buildingMap.get("id")).equals(StringUtils.toString(peopleMap.get("building_id")))) {
                    Map<String, Object> retMap = new HashMap<String, Object>();
                    buildingMap.put("label_id", peopleMap.get("second_level_id"));
                    retMap.putAll(buildingMap);
                    retList.add(retMap);
                }
            }
        }
        return retList;
    }

    @ApiOperation(value = "根据ID查询各个层级数据", desc = "根据ID查询各个层级数据")
    public Map<String, Object> getGridInfoByID(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("id"))) {
            throw new CustomException("缺少参数！");
        }
        if (StringUtils.isEmpty(map.get("grade"))) {
            throw new CustomException("缺少参数！");
        }
        String grade = StringUtils.toString(map.get("grade"));
        Map<String, Object> retMap = new HashMap<>();
        switch (grade) {
            case "3":
            case "4":
            case "5":
            case "6":
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                retMap = commonService.getObject(nameSpace + "getCompanyInfoById", map);
                break;
//            case "5.5":
//                retMap = commonService.getObject(nameSpace + "getResidentialInfoByID",map);
//                break;
            case "7":
                retMap = commonService.getObject(nameSpace + "getGardenInfoByID", map);
                break;
            case "8":
                retMap = commonService.getObject(nameSpace + "getBuildingInfoByID", map);
                break;
            default:
                retMap = commonService.getObject(nameSpace + "getCompanyInfoById", map);
                break;
        }
        return retMap;
    }

    @ApiOperation(value = "地图点击网格查询信息", desc = "地图点击网格查询信息")
    public Map<String, Object> getGridInfoByPolygon(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("type"))) {
            throw new CustomException("缺少参数！");
        }
        if (StringUtils.isEmpty(map.get("id"))) {
            throw new CustomException("缺少参数！");
        }
        String type = StringUtils.toString(map.get("type"));
        Map<String, Object> retMap = new HashMap<>();
        switch (type) {
            case "area":
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                retMap = commonService.getObject(nameSpace + "getCompanyInfoById", map);
                break;
            case "residential":
                DataSourceSwitcher.setSharding("grid");
                DataSourceSwitcher.setSlave();
                retMap = commonService.getObject(nameSpace + "getResidentialInfoByID", map);
                break;
            case "garden":
                DataSourceSwitcher.setSharding("grid");
                DataSourceSwitcher.setSlave();
                retMap = commonService.getObject(nameSpace + "getGardenInfoByID", map);
                break;
            default:
        }
        return retMap;
    }

    /**
     * @param map:
     * @File: NewGridLevelServiceImpl
     * @Method: findGridChildrenList
     * @Description:
     * @author GuoHui
     * @creed: Talk is cheap,show me the code
     * @date 2022/7/7 11:27
     */
    @ApiOperation(value = "tree查询层级", desc = "tree查询层级")
    public List<Map<String, Object>> findGridChildrenList(Map<String, Object> map) {
        String grade = StringUtils.toString(map.get("grade"));
        List<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        switch (grade) {
            case "2":
                // 查市级
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                retList = commonService.findList(nameSpace + "findAreaList", map);
                break;
            case "3":
                // 查询区
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                retList = commonService.findList(nameSpace + "findStreetList", map);
                break;
            case "4":
                // 查询街道
                DataSourceSwitcher.setSharding("sc");
                DataSourceSwitcher.setSlave();
                retList = commonService.findList(nameSpace + "findCommunityList", map);
                break;
            case "5":
                // 查询社区
                retList = commonService.findList(nameSpace + "findSnsList", map);
                break;
            case "6":
                // 查询网格
                retList = commonService.findList(nameSpace + "findGardenCommunityByIdList", map);
                break;
            case "6.5":
                // 查询楼
                retList = commonService.findList(nameSpace + "findBuildingResidentialList", map);
                break;
            case "7":
                // 查询小区
                retList = commonService.findList(nameSpace + "findBuildingResidentialList", map);
//                retList = commonService.findList(nameSpace + "findResidentialList" , map);
                break;
            case "8":
                // 查询单元
                retList = commonService.findList(nameSpace + "findUnitList", map);
                break;
            case "9":
                retList = commonService.findList(nameSpace + "findFloorList", map);
                // 查询本单元包含重点人群的户
                if (retList.size() != 0) {
                    for (Map<String, Object> aMap : retList) {
                        map.put("floor_id", aMap.get("id"));
                        List<Map<String, Object>> levelList = commonService.findList(nameSpace + "findDoorplateList", map);
                        aMap.put("children", levelList);
                    }
                }
                break;
            case "10":
                map.put("floor_id", map.get("id"));
                retList = commonService.findList(nameSpace + "findDoorplateList", map);
                break;
            default:
        }
        return retList;
    }

    @ApiOperation(value = "根据id查询下级所有场所/物件/社会组织/党组织", desc = "根据id查询下级所有场所/物件/社会组织/党组织" ,nologin = true)
    public List<ResMssoVo> findMssoById(ReqMssoVo reqMssoVo) {
        String grade = reqMssoVo.getGrade();
        String businessCode = reqMssoVo.getBusinessCode();
        List<ResMssoVo> mssoVoList = Lists.newArrayList();
        //2:省 3:市 4:区  5:街道  6:社区  7:网格  8:楼   9:单元  10:层  11:户
        if (grade.equals("3") || grade.equals("4") || grade.equals("5") || grade.equals("6") || grade.equals("7")) {
            // 市级、区、街道、社区、网格
            switch (businessCode) {
                case "MERCHANT":
                    mssoVoList = commonService.findList(nameSpace+"findMerchantByCity", reqMssoVo);
                    break;
                case "SOCIETY":
                    mssoVoList = commonService.findList(nameSpace+"findSocietyByCity", reqMssoVo);
                    break;
                case "SUBSTANCE":
                    mssoVoList = commonService.findList(nameSpace+"findSubstanceByCity", reqMssoVo);
                    break;
                case "ORG":
                    mssoVoList = commonService.findList(nameSpace+"findOrgByCity", reqMssoVo);
                    break;
                default:

            }
        } else {
            throw new CustomException("无对应级别数据!");
        }

        return mssoVoList;
    }


    @ApiOperation(value = "查询", desc = "查询")
    public List<Map<String, Object>> findCommunitySchoolList(Map<String, Object> map) {
        return commonService.findList(nameSpace + "findCommunitySchoolList", map);
    }

    @ApiOperation(value = "新增", desc = "新增")
    public String createSchoolInfo(Map<String, Object> map) {
        if (commonService.insert(nameSpace + "createSchoolInfo", map) != 1) {
            throw new CustomException("操作失败！");
        }
        return "success";
    }

    @ApiOperation(value = "修改", desc = "修改")
    public String updateSchoolInfo(Map<String, Object> map) {
        if (commonService.insert(nameSpace + "updateSchoolInfo", map) != 1) {
            throw new CustomException("操作失败！");
        }
        return "success";
    }

    @ApiOperation(value = "删除", desc = "删除")
    public String deleteSchoolInfo(Map<String, Object> map) {
        if (commonService.insert(nameSpace + "deleteSchoolInfo", map) != 1) {
            throw new CustomException("操作失败！");
        }
        return "success";
    }

    @ApiOperation(value = "统计", desc = "统计")
    public Page findSchoolInfoTJList(Page page) {
        return commonService.findPage(nameSpace + "findSchoolInfoTJList", page);
    }

    @ApiOperation(value = "新增地图场所", desc = "新增地图场所")
    public Map<String, Object> addPlace(Map<String, Object> map) {
//		GridSwitch(map);
        Map<String, Object> placeInfo = (Map<String, Object>) map.get("placeInfo");
        Map<String, Object> pickInfo = (Map<String, Object>) map.get("pickInfo");
        if (StringUtils.isEmpty(placeInfo.get("name"))) {
            throw new CustomException("缺少参数：name");
        }
        if (StringUtils.isEmpty(placeInfo.get("merchant_type"))) {
            throw new CustomException("缺少参数：merchant_type");
        }
        String merchant_type = StringUtils.toString(placeInfo.get("merchant_type"));
//        if(!("Z0001".equals(merchant_type))){
//            if("HT".equals(placeInfo.get("mapType"))){
//                if(StringUtils.isEmpty(placeInfo.get("csc_mapjson_ht"))) {
//                    throw new CustomException("缺少参数：csc_mapjson_ht");
//                }
//            }
//            if("GD".equals(placeInfo.get("mapType"))){
//                if(StringUtils.isEmpty(placeInfo.get("csc_mapjson"))) {
//                    throw new CustomException("缺少参数：csc_mapjson");
//                }
//            }
//        }
        if (StringUtils.isEmpty(placeInfo.get("id"))) {
            // 新增
            Map<String, Object> resultMap = commonService.getObject(nameSpace_gridLevel+"getGridGardenById", pickInfo);
            if (resultMap == null) {
                throw new CustomException("查询上级失败！");
            }
            placeInfo.put("company_code", resultMap.get("company_code"));
            placeInfo.put("city_id", resultMap.get("city_id"));
            placeInfo.put("area_id", resultMap.get("area_id"));
            placeInfo.put("street_id", resultMap.get("street_id"));
            placeInfo.put("community_id", resultMap.get("community_id"));
            placeInfo.put("garden_id", resultMap.get("id"));
            if (commonService.insert(nameSpace_gridLevel+"insertPlace", placeInfo) != 1) {
                throw new CustomException("新增失败！");
            }
        } else {
            // 修改
            if (commonService.update(nameSpace_gridLevel+"updatePlace", placeInfo) != 1) {
                throw new CustomException("修改失败！");
            }
        }
        return placeInfo;
    }

    @ApiOperation(value = "新增地图社会组织", desc = "新增地图社会组织")
    public Map<String, Object> addSociety(Map<String, Object> map) {
//		GridSwitch(map);
        Map<String, Object> societyInfo = (Map<String, Object>) map.get("societyInfo");
        Map<String, Object> pickInfo = (Map<String, Object>) map.get("pickInfo");
        if (StringUtils.isEmpty(societyInfo.get("name"))) {
            throw new CustomException("缺少参数：name");
        }
        if(StringUtils.isEmpty(societyInfo.get("mapType"))) {
            throw new CustomException("缺少参数：mapType");
        }
        if("HT".equals(societyInfo.get("mapType"))){
            if(StringUtils.isEmpty(societyInfo.get("csc_mapjson_ht"))) {
                throw new CustomException("缺少参数：csc_mapjson_ht");
            }
        }
        if("GD".equals(societyInfo.get("mapType"))){
            if(StringUtils.isEmpty(societyInfo.get("csc_mapjson"))) {
                throw new CustomException("缺少参数：csc_mapjson");
            }
        }
        if(!IdcardUtil.isValidCard(MapUtil.getStr(societyInfo, "fr_cardno"))) {
        	throw new CustomException("法人身份证号格式异常");
        }
        if(!Validator.isMobile(MapUtil.getStr(societyInfo, "fr_phone"))) {
        	throw new CustomException("法人电话号码格式异常，需要为手机号码");
        }
        if (StringUtils.isEmpty(societyInfo.get("id"))) {
            // 新增
            Map<String, Object> resultMap = commonService.getObject(nameSpace_gridLevel+"getGridGardenById", pickInfo);
            if (resultMap == null) {
                throw new CustomException("查询上级失败！");
            }
            societyInfo.put("company_code", resultMap.get("company_code"));
            societyInfo.put("city_id", resultMap.get("city_id"));
            societyInfo.put("area_id", resultMap.get("area_id"));
            societyInfo.put("street_id", resultMap.get("street_id"));
            societyInfo.put("community_id", resultMap.get("community_id"));
            societyInfo.put("garden_id", resultMap.get("id"));
            if (commonService.insert(nameSpace_gridLevel+"insertSociety", societyInfo) != 1) {
                throw new CustomException("新增失败！");
            }
        } else {
            // 修改
            if (commonService.update(nameSpace_gridLevel+"updateSociety", societyInfo) != 1) {
                throw new CustomException("修改失败！");
            }
        }
        return societyInfo;
    }

}
