package com.scpyun.platform.jilinsscgsdp.service.impl;

import cn.hutool.core.util.IdUtil;
import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.enums.ScoreCategoryEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Author liu
 * @Date 2025/9/25 16:50
 * @PackageName:com.scpyun.platform.jilinsscgsdp.service.impl
 * @ClassName: KeyPersonRating
 * @Description: TODO
 * @Version 1.0
 */
@Api("评分周期设置")
@Service("keyPersonRatingDay")
public class KeyPersonRatingDayServiceImpl {
    @Autowired
    CommonService commonService;

    private final String SUCCESS = "success";

    private String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyPersonRatingDay.";

    @ApiOperation(value = "查询评分周期设置列表", desc = "按类别可选过滤，默认返回全部，合并字典中文名称")
    public List<Map<String, Object>> selectRatingDayList(Map<String, Object> map) {
        return commonService.findList(namespace + "selectRatingDayList", map);
    }

    @ApiOperation(value = "保存评分周期设置", desc = "同一类别仅保留一条记录：存在则更新，不存在则新增")
    public String saveRatingDay(Map<String, Object> map) {
        if (map == null) {
            throw new CustomException("参数不能为空");
        }
        Object type = map.get("rating_dict_type");
        if (type == null || StringUtils.isBlank(String.valueOf(type))) {
            throw new CustomException("缺少重点人员类别");
        }
        requireNonNegative(map, "rating_start_day", "评分开始循环天");
        requireNonNegative(map, "rating_end_day", "评分结束循环天");
        requireNonNegative(map, "rating_over_day", "评分临期提醒天");

        Map<String, Object> exists = commonService.getObject(namespace + "getByType", map);
        if (exists == null) {
            int n = commonService.insert(namespace + "insertRatingDay", map);
            if (n != 1) {
                throw new CustomException("保存失败");
            }
        } else {
            int n = commonService.update(namespace + "updateRatingDay", map);
            if (n < 0) {
                throw new CustomException("保存失败");
            }
        }
        return SUCCESS;
    }

    private void requireNonNegative(Map<String, Object> map, String key, String label) {
        Object v = map.get(key);
        if (v == null || StringUtils.isBlank(String.valueOf(v))) {
            throw new CustomException(label + "不能为空");
        }
        try {
            BigDecimal num = new BigDecimal(String.valueOf(v));
            if (num.compareTo(BigDecimal.ZERO) < 0) {
                throw new CustomException(label + "必须为非负数");
            }
        } catch (NumberFormatException ex) {
            throw new CustomException(label + "必须为数字");
        }
    }
}
