import request from '@/utils/request'

/**
* 显示客户端参数
*
* @param projcetId 项目ID
* @returns 客户端参数信息
*/
export function showClientParams(projcetId) {
  return request({
      url: '/key/client/showClientParams?projectid=' + projcetId,
      method: 'get'
    }) 
}

/**
* 保存客户端参数
*
* @param {any} data - 需要保存的客户端参数数据
* @returns {Promise} - 返回Promise对象，用于处理异步请求结果
*/
export function saveClientParams(data) {
  return request({
      url: '/key/client/saveClientParams',
      method: 'post',
      data: data
    }) 
}