import request from '@/utils/request'

/**
 * 加密算法 - 查询列表
 * @param {*} data 
 * @returns 
 */
export function query(data) {
  return request({
    url: '/core/dataareasecretkey/query',
    method: 'post',
    data: data
  })
}

/**
 * 加密算法 - 查询加密规则
 * @param {*} data 
 * @returns 
 */
export function queryenc(data) {
  return request({
    url: '/core/dataareasecretkey/queryenc',
    method: 'post',
    data: data
  })
}

/**
 * 加密算法 - 查询密钥
 * @param {*} data 
 * @returns 
 */
export function querysec(data) {
  return request({
    url: '/core/dataareasecretkey/querysec',
    method: 'post',
    data: data
  })
}

/**
 * 加密算法 - 新增算法
 * @param {*} data 
 * @returns 
 */
export function save(data) {
  return request({
    url: '/core/dataareasecretkey/save',
    method: 'post',
    data: data
  })
}

/**
 * 加密算法 - 删除算法
 * @param {*} data 
 * @returns 
 */
export function del(data) {
  return request({
    url: '/core/dataareasecretkey/delete',
    method: 'post',
    data: data
  })
}