import request from '@/utils/request'
import { parseStrEmpty } from "@/utils/ruoyi"

/**
 * 密管方式列表
 * @param {*} query 
 * @returns 
 */
export function queryKeys(query) {
  return request({
    url: '/key/manager/queryKeys',
    method: 'get',
    params: query
  })
}

/**
 * 修改使用的密管方式
 */
export function editIsUse(data) {
  return request({
    url: '/key/manager/editIsUse',
    method: 'post',
    data: data
  })
}

/**
 * 参数配置
 * @param {*} query 
 * @returns 
 */
export function showKeyParams(query) {
  return request({
    url: 'key/manager/showKeyParams',
    method: 'get',
    params: query
  })
}

/**
 * 
 * @param {*} query 
 * @returns 
 */
export function testCallKey(query) {
  return request({
    url: 'key/manager/testCallKey',
    method: 'get',
    params: query
  })
}

/** * 参数配置区域
 * @param {*} data
 * @returns {string} 
 */
export function saveKeyParams(data) {
  return request({
      url: '/key/manager/saveKeyParams',
      method: 'post',
      data: data
    })
}


export function uploadHsmConfig(formData) {
  return request({
    url: '/key/manager/uploadHsmConfig',
    method: 'post',
    data: formData,
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}