import request from '@/utils/request'
import { parseStrEmpty } from "@/utils/ruoyi"

/**
 * 用户列表查询
 * @param {*} query 
 * @returns 
 */
export function query(query) {
  return request({
    url: '/console/user/query',
    method: 'get',
    params: query
  })
}

/**
 * 用户编辑初始化
 * @param {*} query 
 * @returns 
 */
export function initEdit(query) {
  return request({
    url: '/console/user/initEdit',
    method: 'get',
    params: query
  })
}


/**
 * 添加用户
 * @param {*} data 
 * @returns 
 */
export function add(data) {
  return request({
    url: '/console/user/add',
    method: 'post',
    data: data
  })
}