import request from '@/utils/request'

/**
 * 脱敏算法 - 查询规则
 * @param {*} query 
 * @returns 
 */
export function query(query) {
  return request({
    url: '/core/desensitizationrule/query',
    method: 'get',
    params: query
  })
}

/**
 * 脱敏算法 - 新增算法
 * @param {*} data 
 * @returns 
 */
export function save(data) {
  return request({
    url: '/core/desensitizationrule/save',
    method: 'post',
    data: data
  })
}

/**
 * 脱敏算法 - 获取函数列表
 * @param {*} query 
 * @returns 
 */
export function queryFunctionList(query) {
  return request({
    url: '/core/desensitizationAlgorithm/queryFunctionList',
    method: 'get',
    params: query
  })
}

/**
 * 脱敏算法 - 删除算法
 * @param {*} data 
 * @returns 
 */
export function del(data) {
  return request({
    url: '/core/desensitizationrule/delete',
    method: 'post',
    data: data
  })
}

/**
 * 脱敏算法 - 测试算法
 * @param {*} data 
 * @returns 
 */
export function test(data) {
  return request({
    url: '/core/desensitizationrule/test',
    method: 'post',
    data: data
  })
}