import { queryCharset } from './index'

// 连接类型
export const oracleisinsData = [
  { key: "服务名", value: "0", label: "服务名" },
  { key: "实例名", value: "1", label: "实例名" },
]

// 字符编码
export const getCode = (key) => {
  if (!key) return
  const list = JSON.parse(sessionStorage.getItem(key))
  return list
}

// 全部字符编码
export const getCueryCharset = async () => {
  if (sessionStorage.getItem('mysql')) return
  const databaseTypeList = ['mysql', 'oracle', 'postgresql', 'hive', 'hive_tdh', 'mssqlserver', 'db2', 'mariadb', 'informix', 'sybase', 'sybaseiq', 'sybaseiq', 'gbase', 'gbase8s', 'gbase8a', 'kingbase', 'dm', 'oscar', 'uxdb', 'greenplum', 'teradata', 'highgo', 'cache', 'hadoop', 'gauss', 'oceanbase', 'mongodb', 'es', 'KAFKA', 'gaussdb']
  for (let i = 0; i < databaseTypeList.length; i++) {
    const data = await queryCharset({ dbtype: databaseTypeList[i] })
    sessionStorage.setItem(databaseTypeList[i].toLowerCase(), JSON.stringify(data.data))
  }
}